/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.web.activity.request;

import com.aspectran.utils.annotation.jsr305.NonNull;
import com.aspectran.utils.annotation.jsr305.Nullable;
import jakarta.servlet.ServletRequest;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public final class RequestAttributeMap
implements Map<String, Object> {
    private ServletRequest request;

    public ServletRequest getRequest() {
        return this.request;
    }

    public void setRequest(@NonNull ServletRequest request) {
        this.request = request;
    }

    private void checkState() {
        if (this.request == null) {
            throw new IllegalStateException("ServletRequest is not specified");
        }
    }

    @Override
    public int size() {
        if (this.request == null) {
            return 0;
        }
        return Collections.list(this.request.getAttributeNames()).size();
    }

    @Override
    public boolean isEmpty() {
        if (this.request == null) {
            return true;
        }
        return !this.request.getAttributeNames().hasMoreElements();
    }

    @Override
    public boolean containsKey(Object key) {
        if (this.request == null) {
            return false;
        }
        return this.request.getAttribute((String)key) != null;
    }

    @Override
    public boolean containsValue(Object value) {
        if (this.request == null) {
            return false;
        }
        Enumeration names = this.request.getAttributeNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            Object object = this.request.getAttribute(name);
            if (!Objects.equals(value, object)) continue;
            return true;
        }
        return false;
    }

    @Override
    @NonNull
    public Object get(Object key) {
        if (this.request == null) {
            return null;
        }
        return this.request.getAttribute((String)key);
    }

    @Override
    public Object put(String name, Object value) {
        this.checkState();
        Object old = this.request.getAttribute(name);
        this.request.setAttribute(name, value);
        return old;
    }

    @Override
    public Object remove(@NonNull Object key) {
        this.checkState();
        Object old = this.request.getAttribute((String)key);
        this.request.removeAttribute((String)key);
        return old;
    }

    @Override
    public void putAll(@Nullable Map<? extends String, ?> map) {
        this.checkState();
        if (map != null) {
            for (Map.Entry<String, ?> entry : map.entrySet()) {
                this.request.setAttribute(entry.getKey(), entry.getValue());
            }
        }
    }

    @Override
    public void clear() {
        if (this.request != null) {
            for (String name : Collections.list(this.request.getAttributeNames())) {
                this.request.removeAttribute(name);
            }
        }
    }

    @Override
    @NonNull
    public Set<String> keySet() {
        if (this.request == null) {
            return Collections.emptySet();
        }
        return Set.copyOf(Collections.list(this.request.getAttributeNames()));
    }

    @Override
    @NonNull
    public Collection<Object> values() {
        if (this.request == null) {
            return Collections.emptyList();
        }
        ArrayList<Object> list = new ArrayList<Object>();
        Enumeration names = this.request.getAttributeNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            Object value = this.request.getAttribute(name);
            list.add(value);
        }
        return Collections.unmodifiableList(list);
    }

    @Override
    @NonNull
    public Set<Map.Entry<String, Object>> entrySet() {
        if (this.request == null) {
            return Collections.emptySet();
        }
        HashSet<AbstractMap.SimpleImmutableEntry<String, Object>> entries = new HashSet<AbstractMap.SimpleImmutableEntry<String, Object>>();
        Enumeration names = this.request.getAttributeNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            Object value = this.request.getAttribute(name);
            entries.add(new AbstractMap.SimpleImmutableEntry<String, Object>(name, value));
        }
        return Collections.unmodifiableSet(entries);
    }
}

