/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.web.activity.request;

import com.aspectran.core.adapter.RequestAdapter;
import com.aspectran.utils.annotation.jsr305.NonNull;
import com.aspectran.web.support.http.HttpMediaTypeNotAcceptableException;
import com.aspectran.web.support.http.InvalidMediaTypeException;
import com.aspectran.web.support.http.MediaType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class RequestHeaderParser {
    public static final List<MediaType> MEDIA_TYPE_ALL_LIST = Collections.singletonList(MediaType.ALL);

    @NonNull
    public static List<MediaType> resolveAcceptContentTypes(@NonNull RequestAdapter requestAdapter) throws HttpMediaTypeNotAcceptableException {
        List<String> acceptHeaderValues = requestAdapter.getHeaderValues("Accept");
        if (acceptHeaderValues == null || acceptHeaderValues.isEmpty()) {
            return MEDIA_TYPE_ALL_LIST;
        }
        ArrayList<String> headerValues = new ArrayList<String>(acceptHeaderValues);
        try {
            List<MediaType> mediaTypes = MediaType.parseMediaTypes(headerValues);
            if (mediaTypes != null && !mediaTypes.isEmpty()) {
                MediaType.sortBySpecificityAndQuality(mediaTypes);
                return mediaTypes;
            }
            return MEDIA_TYPE_ALL_LIST;
        }
        catch (InvalidMediaTypeException e) {
            throw new HttpMediaTypeNotAcceptableException("Could not parse 'Accept' header " + String.valueOf(headerValues) + ": " + e.getMessage());
        }
    }
}

