/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.web.activity.request;

import com.aspectran.core.activity.Activity;
import com.aspectran.core.activity.request.RequestBodyParser;
import com.aspectran.core.activity.request.RequestParseException;
import com.aspectran.core.activity.request.SizeLimitExceededException;
import com.aspectran.core.context.rule.type.MethodType;
import com.aspectran.utils.ClassUtils;
import com.aspectran.utils.LinkedMultiValueMap;
import com.aspectran.utils.MultiValueMap;
import com.aspectran.utils.StringUtils;
import com.aspectran.utils.annotation.jsr305.NonNull;
import com.aspectran.utils.annotation.jsr305.Nullable;
import com.aspectran.utils.apon.JsonToParameters;
import com.aspectran.utils.apon.Parameters;
import com.aspectran.utils.apon.XmlToParameters;
import com.aspectran.web.activity.request.MultipartFormDataParser;
import com.aspectran.web.activity.request.MultipartRequestParseException;
import com.aspectran.web.adapter.WebRequestAdapter;
import com.aspectran.web.support.http.MediaType;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;

public abstract class WebRequestBodyParser {
    public static final String MULTIPART_FORM_DATA_PARSER_SETTING_NAME = "multipartFormDataParser";
    public static final String MAX_REQUEST_SIZE_SETTING_NAME = "maxRequestSize";
    private static final Charset DEFAULT_ENCODING = StandardCharsets.ISO_8859_1;
    private static final int BUFFER_SIZE = 1024;

    public static void parseMultipartFormData(@NonNull Activity activity) throws MultipartRequestParseException {
        String multipartFormDataParser = (String)activity.getSetting(MULTIPART_FORM_DATA_PARSER_SETTING_NAME);
        if (multipartFormDataParser == null) {
            throw new MultipartRequestParseException("The setting name 'multipartFormDataParser' for multipart form data parsing is not specified. Please specify 'multipartFormDataParser' via Aspect so that Translet can parse multipart form data.");
        }
        MultipartFormDataParser parser = (MultipartFormDataParser)activity.getBean(multipartFormDataParser);
        if (parser == null) {
            throw new MultipartRequestParseException("No bean named '" + multipartFormDataParser + "' is defined");
        }
        parser.parse(activity.getRequestAdapter());
    }

    @NonNull
    public static String parseBody(WebRequestAdapter requestAdapter) throws IOException, SizeLimitExceededException {
        int bytesRead;
        Charset encoding = WebRequestBodyParser.determineEncoding(requestAdapter);
        InputStream inputStream = requestAdapter.getInputStream();
        long maxSize = requestAdapter.getMaxRequestSize();
        StringBuilder sb = new StringBuilder();
        InputStreamReader reader = new InputStreamReader(inputStream, encoding);
        char[] buffer = new char[1024];
        long bytesTotal = 0L;
        while ((bytesRead = reader.read(buffer)) != -1) {
            if (maxSize > 0L && (bytesTotal += (long)bytesRead) > maxSize) {
                throw new SizeLimitExceededException("Maximum request size exceeded; actual: " + bytesTotal + "; permitted: " + maxSize, bytesTotal, maxSize);
            }
            sb.append(buffer, 0, bytesRead);
        }
        return sb.toString();
    }

    @Nullable
    public static <T extends Parameters> T parseBodyAsParameters(@NonNull WebRequestAdapter requestAdapter, Class<T> requiredType) throws RequestParseException {
        MediaType mediaType = requestAdapter.getMediaType();
        if (mediaType == null) {
            return null;
        }
        if (WebRequestBodyParser.isURLEncodedForm(mediaType)) {
            return WebRequestBodyParser.parseURLEncodedBodyAsParameters(requestAdapter, requiredType);
        }
        if (MediaType.APPLICATION_JSON.equalsTypeAndSubtype(mediaType)) {
            try {
                return JsonToParameters.from(requestAdapter.getBody(), requiredType);
            }
            catch (IOException e) {
                throw new RequestParseException("Failed to parse request body of JSON format to required type [" + requiredType.getName() + "]", e);
            }
        }
        if (MediaType.APPLICATION_APON.equalsTypeAndSubtype(mediaType)) {
            return RequestBodyParser.parseBodyAsParameters(requestAdapter.getBody(), requiredType);
        }
        if (MediaType.APPLICATION_XML.equalsTypeAndSubtype(mediaType)) {
            try {
                return XmlToParameters.from(requestAdapter.getBody(), requiredType);
            }
            catch (IOException e) {
                throw new RequestParseException("Failed to parse request body of XML format to required type [" + requiredType.getName() + "]", e);
            }
        }
        return null;
    }

    public static void parseURLEncodedFormData(WebRequestAdapter requestAdapter) throws RequestParseException {
        try {
            String body = requestAdapter.getBody();
            if (StringUtils.isEmpty(body)) {
                return;
            }
            Charset encoding = WebRequestBodyParser.determineEncoding(requestAdapter);
            MultiValueMap<String, String> multiValueMap = WebRequestBodyParser.parseURLEncodedBody(body, encoding);
            if (multiValueMap != null) {
                requestAdapter.putAllParameters(multiValueMap);
                requestAdapter.setBody(null);
            }
        }
        catch (Exception e) {
            throw new RequestParseException("Could not parse HTTP " + String.valueOf((Object)requestAdapter.getRequestMethod()) + " request body", e);
        }
    }

    public static boolean isMultipartForm(MethodType requestMethod, MediaType mediaType) {
        return MethodType.POST.equals((Object)requestMethod) && MediaType.MULTIPART_FORM_DATA.equalsTypeAndSubtype(mediaType);
    }

    public static boolean isURLEncodedForm(MediaType mediaType) {
        return MediaType.APPLICATION_FORM_URLENCODED.equalsTypeAndSubtype(mediaType);
    }

    @Nullable
    private static <T extends Parameters> T parseURLEncodedBodyAsParameters(WebRequestAdapter requestAdapter, Class<T> requiredType) throws RequestParseException {
        try {
            Charset encoding = WebRequestBodyParser.determineEncoding(requestAdapter);
            MultiValueMap<String, String> multiValueMap = WebRequestBodyParser.parseURLEncodedBody(requestAdapter.getBody(), encoding);
            if (multiValueMap != null && !multiValueMap.isEmpty()) {
                Parameters parameters = (Parameters)ClassUtils.createInstance(requiredType);
                for (Map.Entry entry : multiValueMap.entrySet()) {
                    String name = (String)entry.getKey();
                    for (String value : (List)entry.getValue()) {
                        parameters.putValue(name, (Object)value);
                    }
                }
                return (T)parameters;
            }
        }
        catch (Exception e) {
            throw new RequestParseException("Failed to parse URL-encoded form request body to required type [" + requiredType.getName() + "]", e);
        }
        return null;
    }

    @Nullable
    private static MultiValueMap<String, String> parseURLEncodedBody(String body, Charset encoding) {
        String[] pairs;
        if (StringUtils.isEmpty(body)) {
            return null;
        }
        LinkedMultiValueMap<String, String> multiValueMap = new LinkedMultiValueMap<String, String>();
        for (String pair : pairs = StringUtils.tokenize(body, "&")) {
            String name;
            int idx = pair.indexOf(61);
            if (idx == -1) {
                name = URLDecoder.decode(pair, encoding);
                multiValueMap.add(name, null);
                continue;
            }
            name = URLDecoder.decode(pair.substring(0, idx), encoding);
            String value = URLDecoder.decode(pair.substring(idx + 1), encoding);
            multiValueMap.add(name, value);
        }
        return multiValueMap;
    }

    @NonNull
    private static Charset determineEncoding(@NonNull WebRequestAdapter requestAdapter) {
        Charset encoding = null;
        if (requestAdapter.getMediaType() != null) {
            encoding = requestAdapter.getMediaType().getCharset();
        }
        if (encoding == null && requestAdapter.getEncoding() != null) {
            encoding = Charset.forName(requestAdapter.getEncoding());
        }
        if (encoding == null) {
            encoding = DEFAULT_ENCODING;
        }
        return encoding;
    }
}

