/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.web.activity.response;

import com.aspectran.core.activity.Activity;
import com.aspectran.utils.Assert;
import com.aspectran.utils.BooleanUtils;
import com.aspectran.utils.FilenameUtils;
import com.aspectran.utils.LinkedCaseInsensitiveMultiValueMap;
import com.aspectran.utils.MultiValueMap;
import com.aspectran.utils.StringUtils;
import com.aspectran.utils.annotation.jsr305.NonNull;
import com.aspectran.web.activity.request.RequestHeaderParser;
import com.aspectran.web.activity.response.RestResponse;
import com.aspectran.web.support.http.HttpMediaTypeNotAcceptableException;
import com.aspectran.web.support.http.HttpStatus;
import com.aspectran.web.support.http.MediaType;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Locale;

public abstract class AbstractRestResponse
implements RestResponse {
    private String name;
    private Object data;
    private Boolean prettyPrint;
    private boolean favorPathExtension = true;
    private boolean ignoreUnknownPathExtensions = true;
    private boolean ignoreAcceptHeader = false;
    private MediaType defaultContentType;
    private int status;
    private MultiValueMap<String, String> headers;

    public AbstractRestResponse() {
    }

    public AbstractRestResponse(Object data) {
        this(null, data);
    }

    public AbstractRestResponse(String name, Object data) {
        this.setData(name, data);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Object getData() {
        return this.data;
    }

    @Override
    public boolean hasData() {
        return this.data != null;
    }

    @Override
    public RestResponse setData(Object data) {
        return this.setData(null, data);
    }

    @Override
    public RestResponse setData(String name, Object data) {
        if (name != null && (name = name.trim()).isEmpty()) {
            name = null;
        }
        this.name = name;
        this.data = data;
        return this;
    }

    protected boolean hasPrettyPrint() {
        return this.prettyPrint != null;
    }

    @Override
    public boolean isPrettyPrint() {
        return BooleanUtils.toBoolean(this.prettyPrint);
    }

    @Override
    public void setPrettyPrint(boolean prettyPrint) {
        this.prettyPrint = prettyPrint;
    }

    @Override
    public RestResponse prettyPrint(boolean prettyPrint) {
        this.setPrettyPrint(prettyPrint);
        return this;
    }

    @Override
    public boolean isFavorPathExtension() {
        return this.favorPathExtension;
    }

    @Override
    public void setFavorPathExtension(boolean favorPathExtension) {
        this.favorPathExtension = favorPathExtension;
    }

    @Override
    public RestResponse favorPathExtension(boolean favorPathExtension) {
        this.setFavorPathExtension(favorPathExtension);
        return this;
    }

    @Override
    public boolean isIgnoreUnknownPathExtensions() {
        return this.ignoreUnknownPathExtensions;
    }

    @Override
    public void setIgnoreUnknownPathExtensions(boolean ignoreUnknownPathExtensions) {
        this.ignoreUnknownPathExtensions = ignoreUnknownPathExtensions;
    }

    @Override
    public RestResponse ignoreUnknownPathExtensions(boolean ignoreUnknownPathExtensions) {
        this.setIgnoreUnknownPathExtensions(ignoreUnknownPathExtensions);
        return this;
    }

    @Override
    public boolean isIgnoreAcceptHeader() {
        return this.ignoreAcceptHeader;
    }

    @Override
    public void setIgnoreAcceptHeader(boolean ignoreAcceptHeader) {
        this.ignoreAcceptHeader = ignoreAcceptHeader;
    }

    @Override
    public RestResponse ignoreAcceptHeader(boolean ignoreAcceptHeader) {
        this.setIgnoreAcceptHeader(ignoreAcceptHeader);
        return this;
    }

    @Override
    public MediaType getDefaultContentType() {
        return this.defaultContentType;
    }

    @Override
    public void setDefaultContentType(MediaType defaultContentType) {
        this.defaultContentType = defaultContentType;
    }

    @Override
    public void setDefaultContentType(String defaultContentType) {
        this.defaultContentType = MediaType.parseMediaType(defaultContentType);
    }

    @Override
    public RestResponse defaultContentType(MediaType defaultContentType) {
        this.setDefaultContentType(defaultContentType);
        return this;
    }

    @Override
    public RestResponse ok() {
        this.status = HttpStatus.OK.value();
        return this;
    }

    @Override
    public RestResponse created() {
        return this.created(null);
    }

    @Override
    public RestResponse created(String location) {
        this.status = HttpStatus.CREATED.value();
        this.setHeader("Location", location);
        return this;
    }

    @Override
    public RestResponse accepted() {
        this.status = HttpStatus.ACCEPTED.value();
        return this;
    }

    @Override
    public RestResponse noContent() {
        this.status = HttpStatus.NO_CONTENT.value();
        return this;
    }

    @Override
    public RestResponse movedPermanently() {
        this.status = HttpStatus.MOVED_PERMANENTLY.value();
        return this;
    }

    @Override
    public RestResponse seeOther() {
        this.status = HttpStatus.SEE_OTHER.value();
        return this;
    }

    @Override
    public RestResponse notModified() {
        this.status = HttpStatus.NOT_MODIFIED.value();
        return this;
    }

    @Override
    public RestResponse temporaryRedirect() {
        this.status = HttpStatus.TEMPORARY_REDIRECT.value();
        return this;
    }

    @Override
    public RestResponse badRequest() {
        this.status = HttpStatus.BAD_REQUEST.value();
        return this;
    }

    @Override
    public RestResponse unauthorized() {
        this.status = HttpStatus.UNAUTHORIZED.value();
        return this;
    }

    @Override
    public RestResponse forbidden() {
        this.status = HttpStatus.FORBIDDEN.value();
        return this;
    }

    @Override
    public RestResponse notFound() {
        this.status = HttpStatus.NOT_FOUND.value();
        return this;
    }

    @Override
    public RestResponse methodNotAllowed() {
        this.status = HttpStatus.METHOD_NOT_ALLOWED.value();
        return this;
    }

    @Override
    public RestResponse notAcceptable() {
        this.status = HttpStatus.NOT_ACCEPTABLE.value();
        return this;
    }

    @Override
    public RestResponse conflict() {
        this.status = HttpStatus.CONFLICT.value();
        return this;
    }

    @Override
    public RestResponse preconditionFailed() {
        this.status = HttpStatus.PRECONDITION_FAILED.value();
        return this;
    }

    @Override
    public RestResponse unsupportedMediaType() {
        this.status = HttpStatus.UNSUPPORTED_MEDIA_TYPE.value();
        return this;
    }

    @Override
    public RestResponse internalServerError() {
        this.status = HttpStatus.INTERNAL_SERVER_ERROR.value();
        return this;
    }

    @Override
    public int getStatus() {
        return this.status;
    }

    @Override
    public RestResponse setStatus(int status) {
        this.status = status;
        return this;
    }

    @Override
    public RestResponse setStatus(HttpStatus status) {
        Assert.notNull((Object)status, "'status' must not be null");
        this.status = status.value();
        return this;
    }

    @Override
    public RestResponse setHeader(String name, String value) {
        if (name == null) {
            throw new IllegalArgumentException("Header name must not be null");
        }
        this.touchHeaders().set(name, value);
        return this;
    }

    @Override
    public RestResponse addHeader(String name, String value) {
        if (name == null) {
            throw new IllegalArgumentException("Header name must not be null");
        }
        this.touchHeaders().add(name, value);
        return this;
    }

    protected MultiValueMap<String, String> getHeaders() {
        return this.headers;
    }

    private MultiValueMap<String, String> touchHeaders() {
        if (this.headers == null) {
            this.headers = new LinkedCaseInsensitiveMultiValueMap<String>();
        }
        return this.headers;
    }

    protected abstract List<MediaType> getSupportedContentTypes();

    protected abstract MediaType getContentTypeByPathExtension(String var1);

    protected MediaType determineAcceptContentType(@NonNull Activity activity) throws HttpMediaTypeNotAcceptableException {
        if (this.isFavorPathExtension()) {
            MediaType contentType;
            String path = activity.getTranslet().getRequestName();
            String ext = FilenameUtils.getExtension(path);
            if (StringUtils.hasLength(ext) && (contentType = this.getContentTypeByPathExtension(ext = ext.toLowerCase(Locale.ENGLISH))) != null) {
                return contentType;
            }
            if (!this.isIgnoreUnknownPathExtensions()) {
                throw new HttpMediaTypeNotAcceptableException(this.getSupportedContentTypes());
            }
        }
        if (!this.isIgnoreAcceptHeader()) {
            List<MediaType> acceptContentTypes = RequestHeaderParser.resolveAcceptContentTypes(activity.getRequestAdapter());
            for (MediaType contentType : acceptContentTypes) {
                if (contentType.equalsTypeAndSubtype(MediaType.ALL) && this.getDefaultContentType() != null && this.getSupportedContentTypes().contains(this.getDefaultContentType())) {
                    return this.getDefaultContentType();
                }
                for (MediaType supportedContentType : this.getSupportedContentTypes()) {
                    if (!contentType.includes(supportedContentType)) continue;
                    return contentType;
                }
            }
            if (this.getSupportedContentTypes().contains(this.getDefaultContentType())) {
                return this.getDefaultContentType();
            }
        }
        throw new HttpMediaTypeNotAcceptableException(this.getSupportedContentTypes());
    }

    protected MediaType determineResponseContentType(@NonNull Activity activity, @NonNull MediaType acceptContentType) {
        String encoding;
        Charset charset = acceptContentType.getCharset();
        if (charset == null && (encoding = this.determineIntendedEncoding(activity)) != null) {
            charset = Charset.forName(encoding);
        }
        if (charset != null) {
            return new MediaType(acceptContentType.getType(), acceptContentType.getSubtype(), charset);
        }
        return new MediaType(acceptContentType.getType(), acceptContentType.getSubtype());
    }

    protected String determineIntendedEncoding(@NonNull Activity activity) {
        return activity.getTranslet().getDefinitiveResponseEncoding();
    }
}

