/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.web.activity.response;

import com.aspectran.core.activity.Activity;
import com.aspectran.core.activity.response.transform.AponTransformResponse;
import com.aspectran.core.activity.response.transform.XmlTransformResponse;
import com.aspectran.core.adapter.RequestAdapter;
import com.aspectran.core.adapter.ResponseAdapter;
import com.aspectran.utils.Assert;
import com.aspectran.utils.StringifyContext;
import com.aspectran.utils.ToStringBuilder;
import com.aspectran.utils.annotation.jsr305.NonNull;
import com.aspectran.utils.apon.ObjectToParameters;
import com.aspectran.utils.apon.Parameters;
import com.aspectran.utils.json.JsonWriter;
import com.aspectran.web.activity.response.AbstractRestResponse;
import com.aspectran.web.support.http.HttpMediaTypeNotAcceptableException;
import com.aspectran.web.support.http.HttpStatus;
import com.aspectran.web.support.http.MediaType;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.xml.transform.TransformerException;

public class DefaultRestResponse
extends AbstractRestResponse {
    private static final int MAX_INDENT = 8;
    private static final List<MediaType> supportedContentTypes = List.of(MediaType.TEXT_PLAIN, MediaType.TEXT_HTML, MediaType.APPLICATION_JSON, MediaType.APPLICATION_APON, MediaType.APPLICATION_XML);
    private static final Map<String, MediaType> supportedPathExtensions = Map.of("json", MediaType.APPLICATION_JSON, "apon", MediaType.APPLICATION_APON, "xml", MediaType.APPLICATION_XML, "txt", MediaType.TEXT_PLAIN, "html", MediaType.TEXT_HTML, "htm", MediaType.TEXT_HTML);

    public DefaultRestResponse() {
    }

    public DefaultRestResponse(Object data) {
        super(data);
    }

    public DefaultRestResponse(String label, Object data) {
        super(label, data);
    }

    @Override
    protected List<MediaType> getSupportedContentTypes() {
        return supportedContentTypes;
    }

    @Override
    protected MediaType getContentTypeByPathExtension(String extension) {
        return supportedPathExtensions.get(extension);
    }

    @Override
    public void transform(Activity activity) throws Exception {
        MediaType acceptContentType;
        Assert.notNull((Object)activity, "activity must not be null");
        ResponseAdapter responseAdapter = activity.getResponseAdapter();
        try {
            acceptContentType = this.determineAcceptContentType(activity);
        }
        catch (HttpMediaTypeNotAcceptableException e) {
            responseAdapter.setStatus(HttpStatus.NOT_ACCEPTABLE.value());
            return;
        }
        MediaType responseContentType = this.determineResponseContentType(activity, acceptContentType);
        responseAdapter.setContentType(responseContentType.toString());
        this.transformByContentType(activity, acceptContentType);
        if (this.getHeaders() != null) {
            for (Map.Entry entry : this.getHeaders().entrySet()) {
                String name = (String)entry.getKey();
                List values = (List)entry.getValue();
                for (String value : values) {
                    responseAdapter.addHeader(name, value);
                }
            }
        }
        if (this.getStatus() > 0) {
            responseAdapter.setStatus(this.getStatus());
        }
    }

    protected void transformByContentType(Activity activity, MediaType contentType) throws Exception {
        if (MediaType.APPLICATION_JSON.equalsTypeAndSubtype(contentType)) {
            this.toJSON(activity, this.parseIndent(contentType));
        } else if (MediaType.APPLICATION_APON.equalsTypeAndSubtype(contentType)) {
            this.toAPON(activity, this.parseIndent(contentType));
        } else if (MediaType.APPLICATION_XML.equalsTypeAndSubtype(contentType)) {
            Charset charset = contentType.getCharset();
            String encoding = charset != null ? charset.name() : null;
            this.toXML(activity, encoding, this.parseIndent(contentType));
        } else {
            this.toText(activity);
        }
    }

    private void toJSON(@NonNull Activity activity, int indent) throws IOException {
        RequestAdapter requestAdapter = activity.getRequestAdapter();
        ResponseAdapter responseAdapter = activity.getResponseAdapter();
        Writer writer = responseAdapter.getWriter();
        String callback = requestAdapter.getParameter("callback");
        if (callback != null) {
            writer.write(callback + "(");
        }
        if (this.getName() != null || this.getData() != null) {
            StringifyContext stringifyContext = this.resolveStringifyContext(activity, indent);
            JsonWriter jsonWriter = new JsonWriter(writer);
            jsonWriter.setStringifyContext(stringifyContext);
            if (this.getName() != null) {
                jsonWriter.beginObject();
                jsonWriter.writeName(this.getName());
            }
            jsonWriter.writeValue(this.getData());
            if (this.getName() != null) {
                jsonWriter.endObject();
            }
        }
        if (callback != null) {
            writer.write(")");
        }
    }

    private void toAPON(Activity activity, int indent) throws IOException {
        if (this.getName() != null || this.getData() != null) {
            ResponseAdapter responseAdapter = activity.getResponseAdapter();
            Writer writer = responseAdapter.getWriter();
            StringifyContext stringifyContext = this.resolveStringifyContext(activity, indent);
            Parameters parameters = this.getName() != null ? ObjectToParameters.from(this.getName(), this.getData(), stringifyContext) : ObjectToParameters.from(this.getData(), stringifyContext);
            AponTransformResponse.transform(parameters, writer, stringifyContext);
        }
    }

    private void toXML(Activity activity, String encoding, int indent) throws IOException, TransformerException {
        if (this.getName() != null || this.getData() != null) {
            ResponseAdapter responseAdapter = activity.getResponseAdapter();
            Writer writer = responseAdapter.getWriter();
            StringifyContext stringifyContext = this.resolveStringifyContext(activity, indent);
            Map<String, Object> data = this.getName() != null ? Collections.singletonMap(this.getName(), this.getData()) : this.getData();
            XmlTransformResponse.transform(data, writer, encoding, stringifyContext);
        }
    }

    private void toText(Activity activity) throws IOException {
        if (this.getName() != null || this.getData() != null) {
            ResponseAdapter responseAdapter = activity.getResponseAdapter();
            Writer writer = responseAdapter.getWriter();
            if (this.getData() != null) {
                writer.write(ToStringBuilder.toString(this.getName() + ":", this.getData()));
            }
        }
    }

    @NonNull
    private StringifyContext resolveStringifyContext(@NonNull Activity activity, int indent) {
        StringifyContext stringifyContext = activity.getStringifyContext().clone();
        if (this.hasPrettyPrint()) {
            stringifyContext.setPretty(this.isPrettyPrint());
        }
        if (this.isPrettyPrint() && indent > -1) {
            stringifyContext.setIndentSize(indent);
        }
        return stringifyContext;
    }

    private int parseIndent(@NonNull MediaType contentType) {
        try {
            String indent = contentType.getParameter("indent");
            if (indent != null) {
                int depth = Integer.parseInt(indent);
                return Math.min(depth, 8);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return -1;
    }
}

