/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.web.adapter;

import com.aspectran.core.activity.request.RequestParseException;
import com.aspectran.core.adapter.AbstractRequestAdapter;
import com.aspectran.core.context.rule.type.MethodType;
import com.aspectran.utils.apon.Parameters;
import com.aspectran.utils.logging.Logger;
import com.aspectran.utils.logging.LoggerFactory;
import com.aspectran.web.activity.request.WebRequestBodyParser;
import com.aspectran.web.adapter.WebRequestAdapter;
import com.aspectran.web.support.http.MediaType;

public abstract class AbstractWebRequestAdapter
extends AbstractRequestAdapter
implements WebRequestAdapter {
    private static final Logger logger = LoggerFactory.getLogger(AbstractWebRequestAdapter.class);
    private MediaType mediaType;
    private boolean bodyObtained;

    public AbstractWebRequestAdapter(MethodType requestMethod, Object adaptee) {
        super(requestMethod, adaptee);
    }

    @Override
    public MediaType getMediaType() {
        return this.mediaType;
    }

    protected void setMediaType(MediaType mediaType) {
        this.mediaType = mediaType;
    }

    @Override
    public String getBody() {
        if (!this.bodyObtained) {
            this.bodyObtained = true;
            try {
                String body = WebRequestBodyParser.parseBody(this);
                this.setBody(body);
            }
            catch (Exception e) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Failed to parse request body", e);
                }
                this.setBody(null);
            }
        }
        return super.getBody();
    }

    @Override
    public <T extends Parameters> T getBodyAsParameters(Class<T> requiredType) throws RequestParseException {
        if (this.getMediaType() != null) {
            return WebRequestBodyParser.parseBodyAsParameters(this, requiredType);
        }
        return null;
    }
}

