/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.web.adapter;

import com.aspectran.core.context.rule.type.MethodType;
import com.aspectran.utils.MultiValueMap;
import com.aspectran.utils.StringUtils;
import com.aspectran.web.activity.request.RequestAttributeMap;
import com.aspectran.web.adapter.AbstractWebRequestAdapter;
import com.aspectran.web.adapter.WebRequestAdapter;
import com.aspectran.web.support.http.MediaType;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.security.Principal;
import java.util.Enumeration;
import java.util.Map;

public class HttpServletRequestAdapter
extends AbstractWebRequestAdapter {
    private boolean headersObtained;

    public HttpServletRequestAdapter(MethodType requestMethod, HttpServletRequest request) {
        super(requestMethod, request);
    }

    @Override
    public MultiValueMap<String, String> getHeaderMap() {
        if (!this.headersObtained) {
            this.headersObtained = true;
            HttpServletRequest request = (HttpServletRequest)this.getAdaptee();
            Enumeration headerNames = request.getHeaderNames();
            if (headerNames.hasMoreElements()) {
                MultiValueMap<String, String> multiValueMap = super.getHeaderMap();
                while (headerNames.hasMoreElements()) {
                    String name = (String)headerNames.nextElement();
                    Enumeration values = request.getHeaders(name);
                    while (values.hasMoreElements()) {
                        String value = (String)values.nextElement();
                        multiValueMap.add(name, value);
                    }
                }
            }
        }
        return super.getHeaderMap();
    }

    @Override
    public String getEncoding() {
        return this.getHttpServletRequest().getCharacterEncoding();
    }

    @Override
    public void setEncoding(String encoding) throws UnsupportedEncodingException {
        this.getHttpServletRequest().setCharacterEncoding(encoding);
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.getHttpServletRequest().getInputStream();
    }

    @Override
    public Principal getPrincipal() {
        return this.getHttpServletRequest().getUserPrincipal();
    }

    private HttpServletRequest getHttpServletRequest() {
        return (HttpServletRequest)this.getAdaptee();
    }

    @Override
    public void preparse() {
        String contentType;
        HttpServletRequest request = (HttpServletRequest)this.getAdaptee();
        RequestAttributeMap requestAttributeMap = new RequestAttributeMap();
        requestAttributeMap.setRequest((ServletRequest)request);
        this.setAttributeMap(requestAttributeMap);
        Map parameters = request.getParameterMap();
        if (!parameters.isEmpty()) {
            this.getParameterMap().putAll(parameters);
        }
        if (StringUtils.hasLength(contentType = request.getContentType())) {
            try {
                MediaType mediaType = MediaType.parseMediaType(contentType);
                this.setMediaType(mediaType);
                if (mediaType.getCharset() != null) {
                    this.setEncoding(mediaType.getCharset().name());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.setLocale(request.getLocale());
    }

    @Override
    public void preparse(WebRequestAdapter requestAdapter) {
        if (requestAdapter == this) {
            throw new IllegalStateException("Unable To Replicate");
        }
        this.setAttributeMap(requestAdapter.getAttributeMap());
        this.getParameterMap().putAll(requestAdapter.getParameterMap());
        this.setMediaType(requestAdapter.getMediaType());
        this.setLocale(requestAdapter.getLocale());
    }
}

