/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.web.adapter;

import com.aspectran.core.activity.Activity;
import com.aspectran.core.activity.response.Response;
import com.aspectran.core.activity.response.ResponseException;
import com.aspectran.core.activity.response.transform.TransformResponse;
import com.aspectran.core.adapter.AbstractResponseAdapter;
import com.aspectran.core.context.rule.RedirectRule;
import com.aspectran.core.context.rule.type.FormatType;
import com.aspectran.web.support.util.SendRedirectBasedOnXForwardedProtocol;
import com.aspectran.web.support.util.WebUtils;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.Collection;

public class HttpServletResponseAdapter
extends AbstractResponseAdapter {
    public static final String PROXY_PROTOCOL_AWARE_SETTING_NAME = "proxyProtocolAware";
    private final Activity activity;
    private boolean precommitDone;

    public HttpServletResponseAdapter(HttpServletResponse response, Activity activity) {
        super(response);
        this.activity = activity;
    }

    @Override
    public String getHeader(String name) {
        return this.getHttpServletResponse().getHeader(name);
    }

    @Override
    public Collection<String> getHeaders(String name) {
        return this.getHttpServletResponse().getHeaders(name);
    }

    @Override
    public Collection<String> getHeaderNames() {
        return this.getHttpServletResponse().getHeaderNames();
    }

    @Override
    public boolean containsHeader(String name) {
        return this.getHttpServletResponse().containsHeader(name);
    }

    @Override
    public void setHeader(String name, String value) {
        this.getHttpServletResponse().setHeader(name, value);
    }

    @Override
    public void addHeader(String name, String value) {
        this.getHttpServletResponse().addHeader(name, value);
    }

    @Override
    public String getEncoding() {
        return this.getHttpServletResponse().getCharacterEncoding();
    }

    @Override
    public void setEncoding(String encoding) {
        this.getHttpServletResponse().setCharacterEncoding(encoding);
    }

    @Override
    public String getContentType() {
        return this.getHttpServletResponse().getContentType();
    }

    @Override
    public void setContentType(String contentType) {
        this.getHttpServletResponse().setContentType(contentType);
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        this.precommit();
        return this.getHttpServletResponse().getOutputStream();
    }

    @Override
    public Writer getWriter() throws IOException {
        this.precommit();
        return this.getHttpServletResponse().getWriter();
    }

    @Override
    public void flush() throws IOException {
        if (this.getHttpServletResponse().isCommitted()) {
            this.getHttpServletResponse().flushBuffer();
        }
    }

    @Override
    public void redirect(String location) throws IOException {
        boolean proxyProtocolAware = Boolean.parseBoolean((String)this.activity.getSetting(PROXY_PROTOCOL_AWARE_SETTING_NAME));
        if (proxyProtocolAware) {
            location = SendRedirectBasedOnXForwardedProtocol.getLocation(this.activity.getTranslet(), location);
        }
        this.getHttpServletResponse().sendRedirect(location);
    }

    @Override
    public String redirect(RedirectRule redirectRule) throws IOException {
        String path = WebUtils.createRedirectPath(redirectRule, this.activity);
        String url = this.getHttpServletResponse().encodeRedirectURL(path);
        this.redirect(url);
        return path;
    }

    @Override
    public int getStatus() {
        return this.getHttpServletResponse().getStatus();
    }

    @Override
    public void setStatus(int status) {
        this.getHttpServletResponse().setStatus(status);
    }

    @Override
    public String transformPath(String path) {
        return this.getHttpServletResponse().encodeURL(path);
    }

    private HttpServletResponse getHttpServletResponse() {
        return (HttpServletResponse)this.getAdaptee();
    }

    private void precommit() throws IOException {
        if (!this.precommitDone) {
            TransformResponse transformResponse;
            FormatType formatType;
            this.precommitDone = true;
            Response response = this.activity.getDeclaredResponse();
            if (response instanceof TransformResponse && (formatType = (transformResponse = (TransformResponse)response).getFormatType()) == null) {
                try {
                    response.commit(this.activity);
                }
                catch (ResponseException e) {
                    throw new IOException("Error during pre-commit", e);
                }
            }
        }
    }
}

