/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.web.adapter;

import com.aspectran.core.adapter.AbstractSessionAdapter;
import com.aspectran.core.component.bean.scope.SessionScope;
import com.aspectran.web.adapter.HttpSessionScope;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpSession;
import java.util.Enumeration;

public class HttpSessionAdapter
extends AbstractSessionAdapter {
    public HttpSessionAdapter(HttpServletRequest request) {
        super(request);
    }

    @Override
    public <T> T getAdaptee() {
        return (T)this.getSession(true);
    }

    @Override
    public SessionScope createSessionScope() {
        return new HttpSessionScope();
    }

    @Override
    public String getId() {
        return this.getSession(true).getId();
    }

    @Override
    public long getCreationTime() {
        return this.getSession(true).getCreationTime();
    }

    @Override
    public long getLastAccessedTime() {
        return this.getSession(true).getLastAccessedTime();
    }

    @Override
    public int getMaxInactiveInterval() {
        return this.getSession(true).getMaxInactiveInterval();
    }

    @Override
    public void setMaxInactiveInterval(int interval) {
        this.getSession(true).setMaxInactiveInterval(interval);
    }

    @Override
    public Enumeration<String> getAttributeNames() {
        HttpSession session = this.getSession(false);
        if (session != null) {
            return session.getAttributeNames();
        }
        return null;
    }

    @Override
    public <T> T getAttribute(String name) {
        HttpSession session = this.getSession(false);
        if (session != null) {
            return (T)session.getAttribute(name);
        }
        return null;
    }

    @Override
    public void setAttribute(String name, Object value) {
        if (value != null) {
            HttpSession session = this.getSession(true);
            session.setAttribute(name, value);
        } else {
            HttpSession session = this.getSession(false);
            if (session != null) {
                session.removeAttribute(name);
            }
        }
    }

    @Override
    public void removeAttribute(String name) {
        HttpSession session = this.getSession(false);
        if (session != null) {
            session.removeAttribute(name);
        }
    }

    @Override
    public void invalidate() {
        HttpSession session = this.getSession(false);
        if (session != null) {
            session.invalidate();
        }
    }

    @Override
    public boolean isValid() {
        HttpSession session = this.getSession(false);
        return session != null;
    }

    @Override
    public boolean isNew() {
        HttpSession session = this.getSession(false);
        return session == null || session.isNew();
    }

    public HttpSession getSession(boolean create) {
        return ((HttpServletRequest)super.getAdaptee()).getSession(create);
    }
}

