/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.web.service;

import com.aspectran.core.context.config.AcceptableConfig;
import com.aspectran.core.context.config.AspectranConfig;
import com.aspectran.core.context.config.WebConfig;
import com.aspectran.core.service.CoreService;
import com.aspectran.core.service.DefaultCoreService;
import com.aspectran.core.service.RequestAcceptor;
import com.aspectran.utils.StringUtils;
import com.aspectran.utils.annotation.jsr305.NonNull;
import com.aspectran.utils.annotation.jsr305.Nullable;
import com.aspectran.web.service.DefaultServletHttpRequestHandler;
import com.aspectran.web.service.WebService;
import com.aspectran.web.service.WebServiceClassLoader;
import jakarta.servlet.ServletContext;

public abstract class AbstractWebService
extends DefaultCoreService
implements WebService {
    private final String contextPath;
    private final ServletContext servletContext;
    private final DefaultServletHttpRequestHandler defaultServletHttpRequestHandler;
    private String uriDecoding;
    private boolean trailingSlashRedirect;
    private boolean legacyHeadHandling;

    AbstractWebService(@NonNull ServletContext servletContext, @Nullable CoreService parentService, boolean derived) {
        super(parentService, derived);
        this.contextPath = StringUtils.emptyToNull(servletContext.getContextPath());
        this.servletContext = servletContext;
        this.defaultServletHttpRequestHandler = new DefaultServletHttpRequestHandler(servletContext, this);
    }

    @Nullable
    public String getContextPath() {
        return this.contextPath;
    }

    @Override
    public ServletContext getServletContext() {
        return this.servletContext;
    }

    @NonNull
    public DefaultServletHttpRequestHandler getDefaultServletHttpRequestHandler() {
        return this.defaultServletHttpRequestHandler;
    }

    public String getUriDecoding() {
        return this.uriDecoding;
    }

    protected void setUriDecoding(String uriDecoding) {
        this.uriDecoding = uriDecoding;
    }

    public boolean isTrailingSlashRedirect() {
        return this.trailingSlashRedirect;
    }

    protected void setTrailingSlashRedirect(boolean trailingSlashRedirect) {
        this.trailingSlashRedirect = trailingSlashRedirect;
    }

    public boolean isLegacyHeadHandling() {
        return this.legacyHeadHandling;
    }

    protected void setLegacyHeadHandling(boolean legacyHeadHandling) {
        this.legacyHeadHandling = legacyHeadHandling;
    }

    @Override
    protected void afterContextLoaded() throws Exception {
        super.afterContextLoaded();
        this.setServiceClassLoader(new WebServiceClassLoader(this.getActivityContext().getClassLoader()));
    }

    @Override
    protected void configure(@NonNull AspectranConfig aspectranConfig) {
        WebConfig webConfig;
        if (!this.isDerived()) {
            if (this.getBasePath() == null) {
                this.setBasePath(this.servletContext.getRealPath("/"));
            }
            super.configure(aspectranConfig);
        }
        if ((webConfig = aspectranConfig.getWebConfig()) != null) {
            this.configure(webConfig);
        }
        if (this.getParentService() != null && this.isDerived()) {
            this.setServiceClassLoader(new WebServiceClassLoader(this.getParentService().getActivityContext().getClassLoader()));
        }
    }

    private void configure(@NonNull WebConfig webConfig) {
        this.setUriDecoding(webConfig.getUriDecoding());
        String defaultServletName = webConfig.getDefaultServletName();
        if (defaultServletName != null) {
            this.defaultServletHttpRequestHandler.setDefaultServletName(defaultServletName);
        }
        this.setTrailingSlashRedirect(webConfig.isTrailingSlashRedirect());
        this.setLegacyHeadHandling(webConfig.isLegacyHeadHandling());
        AcceptableConfig acceptableConfig = webConfig.getAcceptableConfig();
        if (acceptableConfig != null) {
            this.setRequestAcceptor(new RequestAcceptor(acceptableConfig));
        }
    }
}

