/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.web.service;

import com.aspectran.utils.ToStringBuilder;
import com.aspectran.utils.logging.Logger;
import com.aspectran.utils.logging.LoggerFactory;
import com.aspectran.utils.thread.ThreadContextHelper;
import com.aspectran.web.service.WebService;
import jakarta.servlet.RequestDispatcher;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpServletResponseWrapper;
import java.io.IOException;

public class DefaultServletHttpRequestHandler {
    private static final Logger logger = LoggerFactory.getLogger(DefaultServletHttpRequestHandler.class);
    private static final String COMMON_DEFAULT_SERVLET_NAME = "default";
    private static final String RESIN_DEFAULT_SERVLET_NAME = "resin-file";
    private static final String WEBLOGIC_DEFAULT_SERVLET_NAME = "FileServlet";
    private static final String WEBSPHERE_DEFAULT_SERVLET_NAME = "SimpleFileServlet";
    private static final String GAE_DEFAULT_SERVLET_NAME = "_ah_default";
    private static final String JEUS_DEFAULT_SERVLET_NAME = "WorkerServlet";
    private final ServletContext servletContext;
    private final WebService webService;
    private String defaultServletName;

    public DefaultServletHttpRequestHandler(ServletContext servletContext, WebService webService) {
        this.servletContext = servletContext;
        this.webService = webService;
    }

    public String getDefaultServletName() {
        return this.defaultServletName;
    }

    public void setDefaultServletName(String defaultServletName) {
        this.defaultServletName = defaultServletName;
    }

    public void lookupDefaultServletName() {
        if ("none".equals(this.defaultServletName)) {
            this.defaultServletName = null;
            return;
        }
        if (this.defaultServletName != null) {
            if (logger.isDebugEnabled()) {
                logger.debug("Default servlet name: " + this.defaultServletName);
            }
            return;
        }
        if (this.servletContext.getNamedDispatcher(COMMON_DEFAULT_SERVLET_NAME) != null) {
            this.defaultServletName = COMMON_DEFAULT_SERVLET_NAME;
        } else if (this.servletContext.getNamedDispatcher(RESIN_DEFAULT_SERVLET_NAME) != null) {
            this.defaultServletName = RESIN_DEFAULT_SERVLET_NAME;
        } else if (this.servletContext.getNamedDispatcher(WEBLOGIC_DEFAULT_SERVLET_NAME) != null) {
            this.defaultServletName = WEBLOGIC_DEFAULT_SERVLET_NAME;
        } else if (this.servletContext.getNamedDispatcher(WEBSPHERE_DEFAULT_SERVLET_NAME) != null) {
            this.defaultServletName = WEBSPHERE_DEFAULT_SERVLET_NAME;
        } else if (this.servletContext.getNamedDispatcher(GAE_DEFAULT_SERVLET_NAME) != null) {
            this.defaultServletName = GAE_DEFAULT_SERVLET_NAME;
        } else if (this.servletContext.getNamedDispatcher(JEUS_DEFAULT_SERVLET_NAME) != null) {
            this.defaultServletName = JEUS_DEFAULT_SERVLET_NAME;
        } else if (logger.isDebugEnabled()) {
            logger.debug("Unable to locate the default servlet for serving static content. Please set the 'web.defaultServletName' property explicitly.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean handleRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (this.defaultServletName != null) {
            ClassLoader origClassLoader = ThreadContextHelper.overrideClassLoader(this.webService.getServiceClassLoader());
            try {
                this.dispatch(request, response);
            }
            finally {
                ThreadContextHelper.restoreClassLoader(origClassLoader);
            }
            return true;
        }
        return false;
    }

    private void dispatch(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        RequestDispatcher rd = this.servletContext.getNamedDispatcher(this.defaultServletName);
        if (rd == null) {
            throw new IllegalStateException("A RequestDispatcher could not be located for the default servlet '" + this.defaultServletName + "'");
        }
        if (logger.isDebugEnabled()) {
            rd.forward((ServletRequest)request, (ServletResponse)new ErrorLoggingHttpServletResponse(response));
        } else {
            rd.forward((ServletRequest)request, (ServletResponse)response);
        }
    }

    private static class ErrorLoggingHttpServletResponse
    extends HttpServletResponseWrapper {
        public ErrorLoggingHttpServletResponse(HttpServletResponse response) {
            super(response);
        }

        public void sendError(int sc, String msg) throws IOException {
            ToStringBuilder tsb = new ToStringBuilder("Response");
            tsb.append("code", sc);
            tsb.append("message", msg);
            logger.debug(tsb.toString());
            super.sendError(sc, msg);
        }

        public void sendError(int sc) throws IOException {
            ToStringBuilder tsb = new ToStringBuilder("Response");
            tsb.append("code", sc);
            logger.debug(tsb.toString());
            super.sendError(sc);
        }
    }
}

