/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.web.service;

import com.aspectran.core.activity.ActivityTerminatedException;
import com.aspectran.core.activity.TransletNotFoundException;
import com.aspectran.core.activity.request.RequestMethodNotAllowedException;
import com.aspectran.core.activity.request.SizeLimitExceededException;
import com.aspectran.core.component.session.MaxSessionsExceededException;
import com.aspectran.core.component.translet.TransletRuleRegistry;
import com.aspectran.core.context.rule.type.MethodType;
import com.aspectran.core.service.CoreService;
import com.aspectran.utils.ExceptionUtils;
import com.aspectran.utils.StringUtils;
import com.aspectran.utils.ToStringBuilder;
import com.aspectran.utils.annotation.jsr305.NonNull;
import com.aspectran.utils.annotation.jsr305.Nullable;
import com.aspectran.utils.logging.Logger;
import com.aspectran.utils.logging.LoggerFactory;
import com.aspectran.utils.thread.ThreadContextHelper;
import com.aspectran.web.activity.WebActivity;
import com.aspectran.web.service.AbstractWebService;
import com.aspectran.web.service.WebService;
import com.aspectran.web.support.util.WebUtils;
import jakarta.servlet.AsyncContext;
import jakarta.servlet.AsyncEvent;
import jakarta.servlet.AsyncListener;
import jakarta.servlet.ServletContext;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.net.URLDecoder;

public class DefaultWebService
extends AbstractWebService {
    private static final Logger logger = LoggerFactory.getLogger(DefaultWebService.class);
    protected volatile long pauseTimeout = -2L;

    DefaultWebService(@NonNull ServletContext servletContext, @Nullable CoreService parentService, boolean derived) {
        super(servletContext, parentService, derived);
    }

    @Override
    public void service(HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (this.checkPaused(response)) {
            return;
        }
        String requestUri = this.getUriDecoding() != null ? URLDecoder.decode(request.getRequestURI(), this.getUriDecoding()) : request.getRequestURI();
        String requestName = WebUtils.getRelativePath(this.getContextPath(), requestUri);
        MethodType requestMethod = MethodType.resolve(request.getMethod(), MethodType.GET);
        String reverseContextPath = WebUtils.getReverseContextPath(request, this.getContextPath());
        if (logger.isDebugEnabled()) {
            logger.debug(this.getRequestInfo(request, reverseContextPath, requestName, requestMethod));
        }
        if (!this.isAcceptable(requestName)) {
            try {
                if (!this.getDefaultServletHttpRequestHandler().handleRequest(request, response)) {
                    this.sendError(response, 404, "Not Exposed");
                }
            }
            catch (Exception e) {
                logger.error("Error while processing with default servlet", e);
                this.sendError(response, 500, null);
            }
            return;
        }
        WebActivity activity = new WebActivity(this, this.getContextPath(), reverseContextPath, request, response);
        activity.setRequestName(requestName);
        activity.setRequestMethod(requestMethod);
        try {
            activity.prepare();
        }
        catch (TransletNotFoundException e) {
            this.transletNotFound(activity);
            return;
        }
        catch (Exception e) {
            this.sendError(activity, e);
            return;
        }
        WebService.bind(activity, (WebService)this);
        if (activity.isAsync() && request.isAsyncSupported()) {
            this.asyncPerform(activity);
        } else {
            this.perform(activity);
        }
    }

    private void asyncPerform(final @NonNull WebActivity activity) {
        AsyncContext asyncContext;
        if (activity.getRequest().isAsyncStarted()) {
            asyncContext = activity.getRequest().getAsyncContext();
            if (activity.getTimeout() != null) {
                try {
                    asyncContext.setTimeout(activity.getTimeout().longValue());
                }
                catch (IllegalStateException ex) {
                    logger.warn("Servlet request has been put into asynchronous mode by an external force. Proceeding with the existing AsyncContext instance, but cannot guarantee the correct behavior of JAX-RS AsyncResponse time-out support.");
                }
            }
        } else {
            asyncContext = activity.getRequest().startAsync();
            if (logger.isDebugEnabled()) {
                logger.debug("Async Started " + String.valueOf(asyncContext));
            }
            if (activity.getTimeout() != null) {
                asyncContext.setTimeout(activity.getTimeout().longValue());
            }
        }
        asyncContext.addListener(new AsyncListener(){

            public void onComplete(AsyncEvent asyncEvent) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Async Completed " + String.valueOf(asyncEvent));
                }
            }

            public void onTimeout(AsyncEvent asyncEvent) {
                if (!activity.isCommitted() && !activity.isExceptionRaised()) {
                    activity.setRaisedException(new ActivityTerminatedException("Async Timeout " + String.valueOf(asyncEvent)));
                } else {
                    logger.error("Async Timeout " + String.valueOf(asyncEvent));
                }
            }

            public void onError(AsyncEvent asyncEvent) {
                logger.error("Async Error " + String.valueOf(asyncEvent));
            }

            public void onStartAsync(AsyncEvent asyncEvent) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Async Started " + String.valueOf(asyncEvent));
                }
            }
        });
        asyncContext.start(() -> {
            this.perform(activity);
            asyncContext.complete();
        });
    }

    private void perform(@NonNull WebActivity activity) {
        ThreadContextHelper.run(this.getServiceClassLoader(), () -> {
            try {
                activity.perform();
            }
            catch (ActivityTerminatedException e) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Activity terminated: " + e.getMessage());
                }
            }
            catch (Exception e) {
                this.sendError(activity, e);
            }
        });
    }

    private void transletNotFound(@NonNull WebActivity activity) {
        if (this.isTrailingSlashRedirect() && activity.getRequestMethod() == MethodType.GET && StringUtils.startsWith(activity.getRequestName(), '/') && !StringUtils.endsWith(activity.getRequestName(), '/')) {
            String requestNameWithTrailingSlash = activity.getRequestName() + "/";
            TransletRuleRegistry transletRuleRegistry = this.getActivityContext().getTransletRuleRegistry();
            if (transletRuleRegistry.contains(requestNameWithTrailingSlash, activity.getRequestMethod())) {
                String location = StringUtils.hasLength(activity.getReverseContextPath()) ? activity.getReverseContextPath() + activity.getRequestName() + "/" : activity.getRequestName() + "/";
                activity.getResponse().setHeader("Location", location);
                activity.getResponse().setHeader("Connection", "close");
                this.sendError(activity.getResponse(), 301, null);
                return;
            }
        }
        try {
            if (!this.getDefaultServletHttpRequestHandler().handleRequest(activity.getRequest(), activity.getResponse())) {
                if (logger.isTraceEnabled()) {
                    logger.trace("No translet mapped for " + activity.getFullRequestName());
                }
                this.sendError(activity.getResponse(), 404, null);
            }
        }
        catch (Exception e) {
            logger.error(e);
            this.sendError(activity.getResponse(), 500, null);
        }
    }

    private void sendError(@NonNull WebActivity activity, Exception e) {
        Throwable t = activity.getRaisedException() != null ? activity.getRaisedException() : e;
        logger.error("Error occurred while processing request: " + activity.getFullRequestName(), t);
        if (!activity.getResponse().isCommitted()) {
            Throwable cause = ExceptionUtils.getRootCause(t);
            if (cause instanceof RequestMethodNotAllowedException) {
                this.sendError(activity.getResponse(), 405, null);
            } else if (cause instanceof SizeLimitExceededException) {
                this.sendError(activity.getResponse(), 413, null);
            } else if (cause instanceof MaxSessionsExceededException) {
                this.sendError(activity.getResponse(), 503, "Max Sessions Exceeded");
            } else {
                this.sendError(activity.getResponse(), 500, null);
            }
        }
    }

    private void sendError(HttpServletResponse response, int sc, String msg) {
        if (logger.isDebugEnabled()) {
            ToStringBuilder tsb = new ToStringBuilder("Response");
            tsb.append("code", sc);
            tsb.append("message", msg);
            logger.debug(tsb.toString());
        }
        try {
            if (msg != null) {
                response.sendError(sc, msg);
            } else {
                response.sendError(sc);
            }
        }
        catch (IOException e) {
            logger.error("Failed to send an error response to the client with status code " + sc, e);
        }
    }

    @NonNull
    private String getRequestInfo(@NonNull HttpServletRequest request, String reverseContextPath, String requestName, MethodType requestMethod) {
        StringBuilder sb = new StringBuilder();
        sb.append((Object)requestMethod).append(" ");
        if (StringUtils.hasLength(reverseContextPath)) {
            sb.append(reverseContextPath);
        }
        sb.append(requestName).append(" ");
        sb.append(request.getProtocol()).append(" ");
        String remoteAddr = request.getHeader("X-Forwarded-For");
        if (StringUtils.hasLength(remoteAddr)) {
            sb.append(remoteAddr);
        } else {
            sb.append(request.getRemoteAddr());
        }
        return sb.toString();
    }

    private boolean checkPaused(@NonNull HttpServletResponse response) {
        if (this.pauseTimeout != 0L) {
            if (this.pauseTimeout == -1L || this.pauseTimeout >= System.currentTimeMillis()) {
                if (logger.isDebugEnabled()) {
                    logger.debug(this.getServiceName() + " is paused, so did not respond to requests");
                }
                this.sendError(response, 503, "Paused");
                return true;
            }
            if (this.pauseTimeout == -2L) {
                logger.warn(this.getServiceName() + " is not yet started");
                this.sendError(response, 503, "Starting... Try again in a moment.");
                return true;
            }
            this.pauseTimeout = 0L;
        }
        return false;
    }
}

