/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.web.service;

import com.aspectran.core.context.config.AspectranConfig;
import com.aspectran.core.service.CoreService;
import com.aspectran.core.service.CoreServiceException;
import com.aspectran.core.service.CoreServiceHolder;
import com.aspectran.core.service.ServiceStateListener;
import com.aspectran.utils.Assert;
import com.aspectran.utils.ResourceUtils;
import com.aspectran.utils.annotation.jsr305.NonNull;
import com.aspectran.utils.annotation.jsr305.Nullable;
import com.aspectran.utils.apon.AponParseException;
import com.aspectran.utils.logging.Logger;
import com.aspectran.utils.logging.LoggerFactory;
import com.aspectran.web.service.DefaultWebService;
import com.aspectran.web.service.WebService;
import com.aspectran.web.servlet.WebActivityServlet;
import com.aspectran.web.websocket.jsr356.ServerEndpointExporter;
import jakarta.servlet.ServletConfig;
import jakarta.servlet.ServletContext;
import java.io.File;
import java.io.IOException;

public class DefaultWebServiceBuilder {
    private static final Logger logger = LoggerFactory.getLogger(DefaultWebServiceBuilder.class);
    private static final String ASPECTRAN_CONFIG_PARAM = "aspectran:config";

    @NonNull
    public static DefaultWebService build(ServletContext servletContext) {
        return DefaultWebServiceBuilder.build(servletContext, null);
    }

    @NonNull
    public static DefaultWebService build(ServletContext servletContext, CoreService parentService) {
        DefaultWebService webService;
        Assert.notNull((Object)servletContext, "servletContext must not be null");
        String aspectranConfigParam = servletContext.getInitParameter(ASPECTRAN_CONFIG_PARAM);
        if (parentService == null && aspectranConfigParam == null) {
            logger.warn("No specified servlet context initialization parameter for instantiating DefaultWebService");
        }
        if (parentService != null) {
            if (aspectranConfigParam != null) {
                AspectranConfig aspectranConfig = DefaultWebServiceBuilder.makeAspectranConfig(servletContext, aspectranConfigParam);
                webService = DefaultWebServiceBuilder.doBuild(servletContext, parentService, aspectranConfig);
            } else {
                webService = DefaultWebServiceBuilder.doBuild(servletContext, parentService);
            }
        } else {
            AspectranConfig aspectranConfig = DefaultWebServiceBuilder.makeAspectranConfig(servletContext, aspectranConfigParam);
            webService = DefaultWebServiceBuilder.doBuild(servletContext, null, aspectranConfig);
        }
        webService.setAltClassLoader(servletContext.getClassLoader());
        WebService.bind(servletContext, (WebService)webService);
        return webService;
    }

    @Nullable
    public static DefaultWebService build(WebActivityServlet servlet) {
        return DefaultWebServiceBuilder.build(servlet, null);
    }

    @Nullable
    public static DefaultWebService build(WebActivityServlet servlet, WebService rootWebService) {
        Assert.notNull((Object)servlet, "servlet must not be null");
        ServletConfig servletConfig = servlet.getServletConfig();
        String aspectranConfigParam = servletConfig.getInitParameter(ASPECTRAN_CONFIG_PARAM);
        if (rootWebService == null && aspectranConfigParam == null) {
            logger.warn("No specified servlet initialization parameter for instantiating DefaultWebService");
        }
        if (rootWebService == null || aspectranConfigParam != null) {
            ServletContext servletContext = servlet.getServletContext();
            AspectranConfig aspectranConfig = DefaultWebServiceBuilder.makeAspectranConfig(servletContext, aspectranConfigParam);
            return DefaultWebServiceBuilder.doBuild(servletContext, rootWebService, aspectranConfig);
        }
        return null;
    }

    @NonNull
    private static DefaultWebService doBuild(ServletContext servletContext, @NonNull CoreService parentService) {
        DefaultWebService webService = new DefaultWebService(servletContext, parentService, true);
        webService.configure(parentService.getAspectranConfig());
        DefaultWebServiceBuilder.setServiceStateListener(webService);
        return webService;
    }

    @NonNull
    private static DefaultWebService doBuild(ServletContext servletContext, @Nullable CoreService parentService, @NonNull AspectranConfig aspectranConfig) {
        DefaultWebService webService = new DefaultWebService(servletContext, parentService, false);
        webService.configure(aspectranConfig);
        DefaultWebServiceBuilder.setServiceStateListener(webService);
        return webService;
    }

    private static AspectranConfig makeAspectranConfig(ServletContext servletContext, String aspectranConfigParam) {
        AspectranConfig aspectranConfig;
        if (aspectranConfigParam != null) {
            if (aspectranConfigParam.startsWith("file:")) {
                String filePath = aspectranConfigParam.substring("file:".length()).stripLeading();
                try {
                    File configFile = new File(servletContext.getRealPath(filePath));
                    aspectranConfig = new AspectranConfig(configFile);
                }
                catch (IOException e) {
                    throw new CoreServiceException("Error parsing Aspectran configuration from file: " + filePath, e);
                }
            } else if (aspectranConfigParam.startsWith("classpath:")) {
                String resourcePath = aspectranConfigParam.substring("classpath:".length()).stripLeading();
                try {
                    aspectranConfig = new AspectranConfig(ResourceUtils.getResourceAsReader(resourcePath));
                }
                catch (IOException e) {
                    throw new CoreServiceException("Error parsing Aspectran configuration from resource: " + resourcePath, e);
                }
            } else {
                try {
                    aspectranConfig = new AspectranConfig(aspectranConfigParam);
                }
                catch (AponParseException e) {
                    throw new CoreServiceException("Error parsing Aspectran configuration from 'aspectran:config' initialization parameter in web.xml", e);
                }
            }
        } else {
            aspectranConfig = new AspectranConfig();
        }
        return aspectranConfig;
    }

    private static void setServiceStateListener(final @NonNull DefaultWebService webService) {
        webService.setServiceStateListener(new ServiceStateListener(){

            @Override
            public void started() {
                CoreServiceHolder.hold(webService);
                ServerEndpointExporter serverEndpointExporter = new ServerEndpointExporter(webService);
                if (serverEndpointExporter.hasServerContainer()) {
                    for (Class<?> endpointClass : serverEndpointExporter.registerEndpoints()) {
                        CoreServiceHolder.hold(endpointClass, (CoreService)webService);
                    }
                }
                webService.getDefaultServletHttpRequestHandler().lookupDefaultServletName();
                webService.pauseTimeout = 0L;
            }

            @Override
            public void stopped() {
                CoreServiceHolder.release(webService);
            }

            @Override
            public void paused(long millis) {
                if (millis > 0L) {
                    webService.pauseTimeout = System.currentTimeMillis() + millis;
                } else {
                    logger.warn("Pause timeout in milliseconds needs to be set to a value of greater than 0");
                }
            }

            @Override
            public void paused() {
                webService.pauseTimeout = -1L;
            }

            @Override
            public void resumed() {
                webService.pauseTimeout = 0L;
            }
        });
    }
}

