/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.web.service;

import com.aspectran.core.context.ActivityContext;
import com.aspectran.core.service.CoreService;
import com.aspectran.utils.Assert;
import com.aspectran.utils.annotation.jsr305.NonNull;
import com.aspectran.utils.annotation.jsr305.Nullable;
import com.aspectran.web.activity.WebActivity;
import com.aspectran.web.service.DefaultWebService;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;

public interface WebService
extends CoreService {
    public static final String ROOT_WEB_SERVICE_ATTR_NAME = WebService.class.getName() + ".ROOT";
    public static final String DERIVED_WEB_SERVICE_ATTR_NAME = WebService.class.getName() + ".DERIVED";

    public ServletContext getServletContext();

    public void service(HttpServletRequest var1, HttpServletResponse var2) throws IOException;

    public static void bind(ServletContext servletContext, WebService service) {
        Assert.notNull((Object)servletContext, "servletContext must not be null");
        Assert.notNull((Object)service, "service must not be null");
        servletContext.setAttribute(ROOT_WEB_SERVICE_ATTR_NAME, (Object)service);
    }

    public static void bind(WebActivity activity, WebService service) {
        Assert.notNull((Object)activity, "activity must not be null");
        Assert.notNull((Object)service, "service must not be null");
        activity.getRequest().setAttribute(DERIVED_WEB_SERVICE_ATTR_NAME, (Object)service);
    }

    @NonNull
    public static DefaultWebService findWebService(ServletContext servletContext) {
        Assert.notNull((Object)servletContext, "servletContext must not be null");
        DefaultWebService webService = WebService.findWebService(servletContext, ROOT_WEB_SERVICE_ATTR_NAME);
        if (webService == null) {
            throw new IllegalStateException("No WebService found");
        }
        return webService;
    }

    @NonNull
    public static DefaultWebService findWebService(ServletRequest servletRequest) {
        Assert.notNull((Object)servletRequest, "servletRequest must not be null");
        DefaultWebService webService = WebService.findWebService(servletRequest, DERIVED_WEB_SERVICE_ATTR_NAME);
        if (webService == null) {
            webService = WebService.findWebService(servletRequest.getServletContext(), ROOT_WEB_SERVICE_ATTR_NAME);
        }
        if (webService == null) {
            throw new IllegalStateException("No WebService found");
        }
        return webService;
    }

    @NonNull
    public static ActivityContext findActivityContext(ServletContext servletContext) {
        return WebService.findWebService(servletContext).getActivityContext();
    }

    public static ActivityContext findActivityContext(ServletRequest servletRequest) {
        return WebService.findWebService(servletRequest).getActivityContext();
    }

    @Nullable
    private static DefaultWebService findWebService(@NonNull ServletContext servletContext, String attrName) {
        Object attr = servletContext.getAttribute(attrName);
        if (attr == null) {
            return null;
        }
        if (!(attr instanceof DefaultWebService)) {
            throw new IllegalStateException("Context attribute [" + String.valueOf(attr) + "] is not of type [" + DefaultWebService.class.getName() + "]");
        }
        DefaultWebService webService = (DefaultWebService)attr;
        return webService;
    }

    @Nullable
    private static DefaultWebService findWebService(@NonNull ServletRequest servletRequest, String attrName) {
        Object attr = servletRequest.getAttribute(attrName);
        if (attr == null) {
            return null;
        }
        if (!(attr instanceof DefaultWebService)) {
            throw new IllegalStateException("Context attribute [" + String.valueOf(attr) + "] is not of type [" + DefaultWebService.class.getName() + "]");
        }
        DefaultWebService webService = (DefaultWebService)attr;
        return webService;
    }
}

