/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.web.servlet;

import com.aspectran.utils.annotation.jsr305.NonNull;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.WriteListener;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpServletResponseWrapper;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;

class NoBodyResponse
extends HttpServletResponseWrapper {
    private final NoBodyOutputStream noBody = new NoBodyOutputStream();
    private PrintWriter writer;
    private boolean didSetContentLength;
    private boolean usingOutputStream;

    NoBodyResponse(HttpServletResponse response) {
        super(response);
    }

    void setContentLength() {
        if (!this.didSetContentLength) {
            if (this.writer != null) {
                this.writer.flush();
            }
            this.setContentLength(this.noBody.getContentLength());
        }
    }

    public void setContentLength(int len) {
        super.setContentLength(len);
        this.didSetContentLength = true;
    }

    public void setContentLengthLong(long len) {
        super.setContentLengthLong(len);
        this.didSetContentLength = true;
    }

    public void setHeader(String name, String value) {
        super.setHeader(name, value);
        this.checkHeader(name);
    }

    public void addHeader(String name, String value) {
        super.addHeader(name, value);
        this.checkHeader(name);
    }

    public void setIntHeader(String name, int value) {
        super.setIntHeader(name, value);
        this.checkHeader(name);
    }

    public void addIntHeader(String name, int value) {
        super.addIntHeader(name, value);
        this.checkHeader(name);
    }

    private void checkHeader(String name) {
        if ("content-length".equalsIgnoreCase(name)) {
            this.didSetContentLength = true;
        }
    }

    public void reset() {
        super.reset();
        this.noBody.reset();
        this.usingOutputStream = false;
        this.writer = null;
        this.didSetContentLength = false;
    }

    public void resetBuffer() {
        super.resetBuffer();
        if (this.writer != null) {
            try {
                NoBodyOutputStream.disableFlush.set(Boolean.TRUE);
                this.writer.flush();
            }
            finally {
                NoBodyOutputStream.disableFlush.remove();
            }
        }
        this.noBody.reset();
    }

    public ServletOutputStream getOutputStream() throws IOException {
        if (this.writer != null) {
            throw new IllegalStateException("Illegal to call getOutputStream() after getWriter() has been called");
        }
        this.usingOutputStream = true;
        return this.noBody;
    }

    public PrintWriter getWriter() throws UnsupportedEncodingException {
        if (this.usingOutputStream) {
            throw new IllegalStateException("Illegal to call getWriter() after getOutputStream() has been called");
        }
        if (this.writer == null) {
            this.writer = new PrintWriter(new OutputStreamWriter((OutputStream)((Object)this.noBody), this.getCharacterEncoding()));
        }
        return this.writer;
    }

    static class NoBodyOutputStream
    extends ServletOutputStream {
        static ThreadLocal<Boolean> disableFlush = new ThreadLocal();
        private int contentLength = 0;

        NoBodyOutputStream() {
        }

        void reset() {
            this.contentLength = 0;
        }

        int getContentLength() {
            return this.contentLength;
        }

        public void write(int b) {
            ++this.contentLength;
        }

        public void write(@NonNull byte[] buf, int offset, int len) throws IOException {
            if (offset < 0 || len < 0 || offset + len > buf.length) {
                throw new IndexOutOfBoundsException("Invalid offset [" + offset + "] and / or length [" + len + "] specified for array of size [" + buf.length + "]");
            }
            this.contentLength += len;
        }

        public void flush() throws IOException {
            if (Boolean.TRUE.equals(disableFlush.get())) {
                super.flush();
            }
        }

        public boolean isReady() {
            throw new UnsupportedOperationException();
        }

        public void setWriteListener(WriteListener writeListener) {
            throw new UnsupportedOperationException();
        }
    }
}

