/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.web.servlet;

import com.aspectran.utils.annotation.jsr305.NonNull;
import com.aspectran.utils.logging.Logger;
import com.aspectran.utils.logging.LoggerFactory;
import com.aspectran.web.servlet.WebActivityServlet;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;

public class SpecificIPAllowedWebActivityServlet
extends WebActivityServlet {
    private static final long serialVersionUID = -2369788867122156319L;
    private static final Logger logger = LoggerFactory.getLogger(SpecificIPAllowedWebActivityServlet.class);
    private static final String DELIMITERS = " ,;\t\r\n\f";
    private Set<String> allowedAddresses;

    @Override
    public void init() throws ServletException {
        String addresses = this.getServletConfig().getInitParameter("allowedAddresses");
        if (addresses != null) {
            this.allowedAddresses = new HashSet<String>();
            StringTokenizer st = new StringTokenizer(addresses, DELIMITERS);
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                this.allowedAddresses.add(token);
            }
        }
        super.init();
    }

    @Override
    public void service(@NonNull HttpServletRequest req, @NonNull HttpServletResponse res) throws IOException {
        String remoteAddr = req.getRemoteAddr();
        if (!this.isAllowedAddress(remoteAddr)) {
            if (logger.isDebugEnabled()) {
                logger.debug("Access Denied: " + remoteAddr);
            }
            res.sendError(403);
            return;
        }
        super.service(req, res);
    }

    private boolean isAllowedAddress(@NonNull String ipAddress) {
        if (this.allowedAddresses == null) {
            return false;
        }
        int offset = ipAddress.lastIndexOf(46);
        if (offset == -1 && (offset = ipAddress.lastIndexOf(58)) == -1) {
            return false;
        }
        String ipAddressClass = ipAddress.substring(0, offset + 1) + "*";
        return this.allowedAddresses.contains(ipAddressClass) || this.allowedAddresses.contains(ipAddress);
    }
}

