/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.web.servlet;

import com.aspectran.utils.ObjectUtils;
import com.aspectran.utils.annotation.jsr305.NonNull;
import com.aspectran.utils.logging.Logger;
import com.aspectran.utils.logging.LoggerFactory;
import com.aspectran.web.service.DefaultWebService;
import com.aspectran.web.service.DefaultWebServiceBuilder;
import com.aspectran.web.service.WebService;
import com.aspectran.web.servlet.NoBodyResponse;
import jakarta.servlet.Servlet;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.UnavailableException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;

public class WebActivityServlet
extends HttpServlet
implements Servlet {
    private static final long serialVersionUID = 6659683668233267847L;
    private static final Logger logger = LoggerFactory.getLogger(WebActivityServlet.class);
    private static final String METHOD_HEAD = "HEAD";
    private DefaultWebService webService;
    private boolean standalone;

    public void init() throws ServletException {
        try {
            DefaultWebService newWebService;
            ServletContext servletContext = this.getServletContext();
            Object attr = servletContext.getAttribute(WebService.ROOT_WEB_SERVICE_ATTR_NAME);
            if (attr != null) {
                if (!(attr instanceof DefaultWebService)) {
                    throw new IllegalStateException("Context attribute [" + String.valueOf(attr) + "] is not of type [" + WebService.class.getName() + "]");
                }
                DefaultWebService rootWebService = (DefaultWebService)attr;
                newWebService = DefaultWebServiceBuilder.build(this, rootWebService);
                if (newWebService == null) {
                    this.webService = rootWebService;
                    this.standalone = false;
                } else {
                    this.standalone = true;
                }
            } else {
                newWebService = DefaultWebServiceBuilder.build(this);
                this.standalone = true;
            }
            if (newWebService != null) {
                newWebService.start();
                this.webService = newWebService;
            }
        }
        catch (Exception e) {
            logger.error("Unable to initialize WebActivityServlet", e);
            throw new UnavailableException(e.getMessage());
        }
        logger.info("Initialized " + this.getMyName());
    }

    public void service(HttpServletRequest req, HttpServletResponse res) throws IOException {
        if (this.webService.isLegacyHeadHandling() && METHOD_HEAD.equals(req.getMethod())) {
            this.doHead(req, res);
        } else {
            this.webService.service(req, res);
        }
    }

    protected void doHead(HttpServletRequest req, HttpServletResponse res) throws IOException {
        NoBodyResponse noBodyResponse = new NoBodyResponse(res);
        this.webService.service(req, (HttpServletResponse)noBodyResponse);
        noBodyResponse.setContentLength();
    }

    public void destroy() {
        super.destroy();
        if (this.standalone) {
            this.webService.stop();
        }
        logger.info("Destroyed " + this.getMyName());
    }

    @NonNull
    private String getMyName() {
        return ObjectUtils.simpleIdentityToString((Object)this, this.getServletName());
    }
}

