/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.web.servlet.filter;

import com.aspectran.utils.ObjectUtils;
import com.aspectran.utils.StringUtils;
import com.aspectran.utils.annotation.jsr305.NonNull;
import com.aspectran.utils.logging.Logger;
import com.aspectran.utils.logging.LoggerFactory;
import com.aspectran.utils.wildcard.WildcardPattern;
import com.aspectran.utils.wildcard.WildcardPatterns;
import com.aspectran.web.service.DefaultServletHttpRequestHandler;
import com.aspectran.web.service.DefaultWebService;
import com.aspectran.web.service.WebService;
import com.aspectran.web.support.util.WebUtils;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;

public class WebActivityFilter
implements Filter {
    private static final Logger logger = LoggerFactory.getLogger(WebActivityFilter.class);
    private static final String BYPASS_PATTERN_DELIMITERS = ",;\t\r\n\f";
    private FilterConfig filterConfig;
    private WildcardPatterns bypassPatterns;
    private DefaultServletHttpRequestHandler defaultServletHttpRequestHandler;

    public void init(@NonNull FilterConfig filterConfig) {
        String[] bypasses;
        this.filterConfig = filterConfig;
        String bypassesParam = filterConfig.getInitParameter("bypasses");
        if (bypassesParam != null && (bypasses = StringUtils.tokenize(bypassesParam, BYPASS_PATTERN_DELIMITERS, true)).length > 0) {
            this.bypassPatterns = WildcardPatterns.of(bypasses, '/');
            ServletContext servletContext = filterConfig.getServletContext();
            DefaultWebService webService = WebService.findWebService(servletContext);
            DefaultServletHttpRequestHandler defaultHandler = new DefaultServletHttpRequestHandler(servletContext, webService);
            defaultHandler.lookupDefaultServletName();
            this.defaultServletHttpRequestHandler = defaultHandler;
            if (logger.isDebugEnabled()) {
                for (WildcardPattern pattern : this.bypassPatterns.getPatterns()) {
                    logger.debug(String.valueOf(pattern) + " is bypassed by " + this.getMyName() + " to servlet '" + defaultHandler.getDefaultServletName() + "'");
                }
            }
        }
        logger.info("Initialized " + this.getMyName());
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (this.bypassPatterns != null && request instanceof HttpServletRequest) {
            HttpServletRequest httpRequest = (HttpServletRequest)request;
            if (response instanceof HttpServletResponse) {
                HttpServletResponse httpResponse = (HttpServletResponse)response;
                String requestName = WebUtils.getRelativePath(httpRequest.getContextPath(), httpRequest.getRequestURI());
                if (this.bypassPatterns.matches(requestName) && this.defaultServletHttpRequestHandler.handleRequest(httpRequest, httpResponse)) {
                    return;
                }
            }
        }
        chain.doFilter(request, response);
    }

    public void destroy() {
        logger.info("Destroyed " + this.getMyName());
    }

    @NonNull
    private String getMyName() {
        return ObjectUtils.simpleIdentityToString(this, this.filterConfig.getFilterName());
    }
}

