/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.web.servlet.listener;

import com.aspectran.utils.ObjectUtils;
import com.aspectran.utils.annotation.jsr305.NonNull;
import com.aspectran.utils.logging.Logger;
import com.aspectran.utils.logging.LoggerFactory;
import com.aspectran.web.service.DefaultWebService;
import com.aspectran.web.service.DefaultWebServiceBuilder;
import com.aspectran.web.service.WebService;
import jakarta.servlet.ServletContextEvent;
import jakarta.servlet.ServletContextListener;

public class WebServiceListener
implements ServletContextListener {
    private static final Logger logger = LoggerFactory.getLogger(WebServiceListener.class);
    private DefaultWebService webService;

    public void contextInitialized(@NonNull ServletContextEvent event) {
        try {
            WebService.findWebService(event.getServletContext());
            logger.warn("Root WebService already exists; Remove WebServiceListener as it is unnecessary");
            return;
        }
        catch (IllegalStateException illegalStateException) {
            logger.info("Creating Root WebService...");
            try {
                this.webService = DefaultWebServiceBuilder.build(event.getServletContext());
                this.webService.start();
                logger.info("Initialized " + this.getMyName());
            }
            catch (Exception e) {
                logger.error("Failed to create root web service", e);
            }
            return;
        }
    }

    public void contextDestroyed(ServletContextEvent event) {
        if (this.webService != null) {
            this.webService.stop();
            this.webService = null;
            logger.info("Destroyed " + this.getMyName());
        }
    }

    @NonNull
    private String getMyName() {
        return ObjectUtils.simpleIdentityToString(this);
    }
}

