/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.web.support.cors;

import com.aspectran.core.activity.Translet;
import com.aspectran.utils.StringUtils;
import com.aspectran.utils.annotation.jsr305.NonNull;
import com.aspectran.utils.logging.Logger;
import com.aspectran.utils.logging.LoggerFactory;
import com.aspectran.web.support.cors.AbstractCorsProcessor;
import com.aspectran.web.support.cors.CorsException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;

public class DefaultCorsProcessor
extends AbstractCorsProcessor {
    private static final Logger logger = LoggerFactory.getLogger(DefaultCorsProcessor.class);
    private static final String CORS_HTTP_STATUS_CODE = "CORS.HTTP_STATUS_CODE";
    private static final String CORS_HTTP_STATUS_TEXT = "CORS.HTTP_STATUS_TEXT";

    @Override
    public void processActualRequest(@NonNull Translet translet) throws CorsException {
        String origin;
        HttpServletRequest req = (HttpServletRequest)translet.getRequestAdaptee();
        HttpServletResponse res = (HttpServletResponse)translet.getResponseAdaptee();
        if (!this.isCorsRequest(req)) {
            return;
        }
        if (!this.checkProcessable(res)) {
            return;
        }
        if (!this.isAllowedMethod(req.getMethod())) {
            this.rejectRequest(translet, CorsException.UNSUPPORTED_METHOD);
        }
        if (!this.isAllowedOrigin(origin = req.getHeader("Origin"))) {
            this.rejectRequest(translet, CorsException.ORIGIN_DENIED);
        }
        if (this.isAllowCredentials()) {
            res.addHeader("Access-Control-Allow-Origin", origin);
            res.addHeader("Access-Control-Allow-Credentials", "true");
            res.addHeader("Vary", "Origin");
        } else {
            res.addHeader("Access-Control-Allow-Origin", this.hasAllowedOrigins() ? origin : "*");
            res.addHeader("Vary", "Origin");
        }
        if (this.getExposedHeadersString() != null) {
            res.setHeader("Access-Control-Expose-Headers", this.getExposedHeadersString());
        }
    }

    @Override
    public void processPreflightRequest(@NonNull Translet translet) throws CorsException {
        String origin;
        String rawRequestHeadersString;
        HttpServletRequest req = (HttpServletRequest)translet.getRequestAdaptee();
        HttpServletResponse res = (HttpServletResponse)translet.getResponseAdaptee();
        if (!this.isPreFlightRequest(req)) {
            this.rejectRequest(translet, CorsException.INVALID_PREFLIGHT_REQUEST);
        }
        if (!this.checkProcessable(res)) {
            return;
        }
        String requestedMethod = req.getHeader("Access-Control-Request-Method");
        if (!this.isAllowedMethod(requestedMethod)) {
            this.rejectRequest(translet, CorsException.UNSUPPORTED_METHOD);
        }
        if ((rawRequestHeadersString = req.getHeader("Access-Control-Request-Headers")) != null && this.hasAllowedHeaders()) {
            String[] requestHeaders;
            for (String requestHeader : requestHeaders = StringUtils.splitCommaDelimitedString(rawRequestHeadersString)) {
                if (this.isAllowedHeader(requestHeader)) continue;
                this.rejectRequest(translet, CorsException.UNSUPPORTED_REQUEST_HEADER);
            }
        }
        if ((origin = req.getHeader("Origin")) != null) {
            if (this.isAllowCredentials()) {
                res.addHeader("Access-Control-Allow-Origin", origin);
                res.addHeader("Access-Control-Allow-Credentials", "true");
                res.addHeader("Vary", "Origin");
            } else {
                res.addHeader("Access-Control-Allow-Origin", this.hasAllowedOrigins() ? origin : "*");
                res.addHeader("Vary", "Origin");
            }
        }
        if (this.getAllowedMethodsString() != null) {
            res.addHeader("Access-Control-Allow-Methods", this.getAllowedMethodsString());
        }
        if (this.getAllowedHeadersString() != null) {
            res.addHeader("Access-Control-Allow-Headers", this.getAllowedHeadersString());
        } else if (rawRequestHeadersString != null) {
            res.addHeader("Access-Control-Allow-Headers", rawRequestHeadersString);
        }
        if (this.getMaxAgeSeconds() > 0) {
            res.addHeader("Access-Control-Max-Age", Integer.toString(this.getMaxAgeSeconds()));
        }
    }

    @Override
    public void sendError(@NonNull Translet translet) throws IOException {
        Throwable t = translet.getRootCauseOfRaisedException();
        if (t instanceof CorsException) {
            CorsException corsException = (CorsException)t;
            HttpServletResponse res = (HttpServletResponse)translet.getResponseAdaptee();
            res.sendError(corsException.getHttpStatusCode(), corsException.getMessage());
        }
    }

    protected void rejectRequest(@NonNull Translet translet, @NonNull CorsException ce) throws CorsException {
        HttpServletResponse res = (HttpServletResponse)translet.getResponseAdaptee();
        res.setStatus(ce.getHttpStatusCode());
        translet.setAttribute(CORS_HTTP_STATUS_CODE, ce.getHttpStatusCode());
        translet.setAttribute(CORS_HTTP_STATUS_TEXT, ce.getMessage());
        throw ce;
    }

    protected boolean checkProcessable(@NonNull HttpServletResponse res) {
        if (res.getHeader("Access-Control-Allow-Origin") != null) {
            if (logger.isDebugEnabled()) {
                logger.debug("Skip CORS processing: response already contains \"Access-Control-Allow-Origin\" header");
            }
            return false;
        }
        return true;
    }
}

