/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.web.support.i18n.locale;

import com.aspectran.core.activity.Translet;
import com.aspectran.core.support.i18n.locale.AbstractLocaleResolver;
import com.aspectran.utils.LocaleUtils;
import com.aspectran.utils.annotation.jsr305.NonNull;
import com.aspectran.utils.annotation.jsr305.Nullable;
import com.aspectran.utils.logging.Logger;
import com.aspectran.utils.logging.LoggerFactory;
import com.aspectran.web.support.util.CookieGenerator;
import com.aspectran.web.support.util.WebUtils;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.Locale;
import java.util.TimeZone;

public class CookieLocaleResolver
extends AbstractLocaleResolver {
    private static final Logger logger = LoggerFactory.getLogger(CookieLocaleResolver.class);
    private static final String LOCALE_COOKIE_NAME = CookieLocaleResolver.class.getName() + ".LOCALE";
    private static final String TIME_ZONE_COOKIE_NAME = CookieLocaleResolver.class.getName() + ".TIME_ZONE";
    private volatile CookieGenerator localeCookieGenerator;
    private volatile CookieGenerator timeZoneCookieGenerator;
    private boolean languageTagCompliant = true;
    private boolean rejectInvalidCookies = true;

    public void setLocaleCookieGenerator(CookieGenerator localeCookieGenerator) {
        this.localeCookieGenerator = localeCookieGenerator;
    }

    public CookieGenerator getLocaleCookieGenerator() {
        if (this.localeCookieGenerator == null) {
            this.localeCookieGenerator = new CookieGenerator();
            this.localeCookieGenerator.setCookieName(LOCALE_COOKIE_NAME);
        }
        return this.localeCookieGenerator;
    }

    public void setTimeZoneCookieGenerator(CookieGenerator timeZoneCookieGenerator) {
        this.timeZoneCookieGenerator = timeZoneCookieGenerator;
    }

    public CookieGenerator getTimeZoneCookieGenerator() {
        if (this.timeZoneCookieGenerator == null) {
            this.timeZoneCookieGenerator = new CookieGenerator();
            this.timeZoneCookieGenerator.setCookieName(TIME_ZONE_COOKIE_NAME);
        }
        return this.timeZoneCookieGenerator;
    }

    public void setCookieDomain(String cookieDomain) {
        this.getLocaleCookieGenerator().setCookieDomain(cookieDomain);
        this.getTimeZoneCookieGenerator().setCookieDomain(cookieDomain);
    }

    public void setCookiePath(String cookiePath) {
        this.getLocaleCookieGenerator().setCookiePath(cookiePath);
        this.getTimeZoneCookieGenerator().setCookiePath(cookiePath);
    }

    public void setCookieMaxAge(Integer cookieMaxAge) {
        this.getLocaleCookieGenerator().setCookieMaxAge(cookieMaxAge);
        this.getTimeZoneCookieGenerator().setCookieMaxAge(cookieMaxAge);
    }

    public void setCookieSecure(boolean cookieSecure) {
        this.getLocaleCookieGenerator().setCookieSecure(cookieSecure);
        this.getTimeZoneCookieGenerator().setCookieSecure(cookieSecure);
    }

    public void setCookieHttpOnly(boolean cookieHttpOnly) {
        this.getLocaleCookieGenerator().setCookieHttpOnly(cookieHttpOnly);
        this.getTimeZoneCookieGenerator().setCookieHttpOnly(cookieHttpOnly);
    }

    public void setLanguageTagCompliant(boolean languageTagCompliant) {
        this.languageTagCompliant = languageTagCompliant;
    }

    public boolean isLanguageTagCompliant() {
        return this.languageTagCompliant;
    }

    public void setRejectInvalidCookies(boolean rejectInvalidCookies) {
        this.rejectInvalidCookies = rejectInvalidCookies;
    }

    public boolean isRejectInvalidCookies() {
        return this.rejectInvalidCookies;
    }

    @Override
    public Locale resolveLocale(@NonNull Translet translet) {
        Locale locale = this.parseLocaleCookie(translet);
        if (locale != null) {
            translet.getRequestAdapter().setLocale(locale);
            return locale;
        }
        return this.determineDefaultLocale(translet);
    }

    @Override
    public TimeZone resolveTimeZone(@NonNull Translet translet) {
        TimeZone timeZone = this.parseTimeZoneCookie(translet);
        if (timeZone != null) {
            translet.getRequestAdapter().setTimeZone(timeZone);
            return timeZone;
        }
        return this.determineDefaultTimeZone(translet);
    }

    @Override
    public void setLocale(@NonNull Translet translet, Locale locale) {
        translet.getRequestAdapter().setLocale(locale);
        HttpServletResponse response = (HttpServletResponse)translet.getResponseAdapter().getAdaptee();
        this.getLocaleCookieGenerator().addCookie(response, locale != null ? this.toLocaleValue(locale) : "");
    }

    @Override
    public void setTimeZone(@NonNull Translet translet, TimeZone timeZone) {
        translet.getRequestAdapter().setTimeZone(timeZone);
        HttpServletResponse response = (HttpServletResponse)translet.getResponseAdapter().getAdaptee();
        this.getTimeZoneCookieGenerator().addCookie(response, timeZone != null ? timeZone.getID() : "");
    }

    private Locale parseLocaleCookie(@NonNull Translet translet) {
        Locale locale = null;
        String cookieName = this.getLocaleCookieGenerator().getCookieName();
        HttpServletRequest request = (HttpServletRequest)translet.getRequestAdapter().getAdaptee();
        Cookie cookie = WebUtils.getCookie(request, cookieName);
        if (cookie != null) {
            block5: {
                String value = cookie.getValue();
                try {
                    locale = this.parseLocaleValue(value);
                }
                catch (IllegalArgumentException ex) {
                    if (this.isRejectInvalidCookies() && request.getAttribute("jakarta.servlet.error.exception") == null) {
                        throw new IllegalStateException("Encountered invalid locale cookie '" + cookieName + "': [" + value + "] due to: " + ex.getMessage());
                    }
                    if (!logger.isDebugEnabled()) break block5;
                    logger.debug("Ignoring invalid locale cookie '" + cookieName + "': [" + value + "] due to: " + ex.getMessage());
                }
            }
            if (locale != null && logger.isTraceEnabled()) {
                logger.trace("Parsed cookie value [" + cookie.getValue() + "] into locale '" + String.valueOf(locale) + "'");
            }
        }
        return locale;
    }

    private TimeZone parseTimeZoneCookie(@NonNull Translet translet) {
        TimeZone timeZone = null;
        String cookieName = this.getTimeZoneCookieGenerator().getCookieName();
        HttpServletRequest request = (HttpServletRequest)translet.getRequestAdapter().getAdaptee();
        Cookie cookie = WebUtils.getCookie(request, cookieName);
        if (cookie != null) {
            block5: {
                String value = cookie.getValue();
                try {
                    timeZone = LocaleUtils.parseTimeZoneString(value);
                }
                catch (IllegalArgumentException ex) {
                    if (this.isRejectInvalidCookies() && request.getAttribute("jakarta.servlet.error.exception") == null) {
                        throw new IllegalStateException("Encountered invalid time zone cookie '" + cookieName + "': [" + value + "] due to: " + ex.getMessage());
                    }
                    if (!logger.isDebugEnabled()) break block5;
                    logger.debug("Ignoring invalid time zone cookie '" + cookieName + "': [" + value + "] due to: " + ex.getMessage());
                }
            }
            if (timeZone != null && logger.isTraceEnabled()) {
                logger.trace("Parsed cookie value [" + cookie.getValue() + "] into time zone '" + timeZone.getID() + "'");
            }
        }
        return timeZone;
    }

    @Nullable
    protected Locale parseLocaleValue(String localeValue) {
        return LocaleUtils.parseLocale(localeValue);
    }

    protected String toLocaleValue(Locale locale) {
        return this.isLanguageTagCompliant() ? locale.toLanguageTag() : locale.toString();
    }
}

