/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.web.support.multipart.inmemory;

import com.aspectran.utils.annotation.jsr305.NonNull;
import com.aspectran.web.support.multipart.inmemory.InMemoryOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemHeaders;
import org.apache.commons.fileupload.FileItemHeadersSupport;
import org.apache.commons.fileupload.ParameterParser;

public class InMemoryFileItem
implements FileItem,
FileItemHeadersSupport {
    public static final String DEFAULT_CHARSET = "ISO-8859-1";
    private String fieldName;
    private final String contentType;
    private boolean isFormField;
    private final String fileName;
    private byte[] cachedContent;
    private transient InMemoryOutputStream mos;
    private final int sizeThreshold;
    private FileItemHeaders headers;

    public InMemoryFileItem(String fieldName, String contentType, boolean isFormField, String fileName, int sizeThreshold) {
        this.fieldName = fieldName;
        this.contentType = contentType;
        this.isFormField = isFormField;
        this.fileName = fileName;
        this.sizeThreshold = sizeThreshold;
    }

    public InputStream getInputStream() throws IOException {
        if (this.cachedContent == null) {
            this.cachedContent = this.mos.getData();
        }
        return new ByteArrayInputStream(this.cachedContent);
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getCharset() {
        ParameterParser parser = new ParameterParser();
        parser.setLowerCaseNames(true);
        Map params = parser.parse(this.getContentType(), ';');
        return (String)params.get("charset");
    }

    public String getName() {
        return this.fileName;
    }

    public boolean isInMemory() {
        return true;
    }

    public long getSize() {
        if (this.cachedContent != null) {
            return this.cachedContent.length;
        }
        return this.mos.getData().length;
    }

    public byte[] get() {
        if (this.cachedContent == null) {
            this.cachedContent = this.mos.getData();
        }
        return this.cachedContent;
    }

    public String getString(String charset) throws UnsupportedEncodingException {
        return new String(this.get(), charset);
    }

    public String getString() {
        byte[] rawData = this.get();
        String charset = this.getCharset();
        if (charset == null) {
            charset = DEFAULT_CHARSET;
        }
        try {
            return new String(rawData, charset);
        }
        catch (UnsupportedEncodingException e) {
            return new String(rawData);
        }
    }

    public void write(File file) throws Exception {
        try (FileOutputStream out = new FileOutputStream(file);){
            out.write(this.get());
        }
    }

    public void delete() {
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    public boolean isFormField() {
        return this.isFormField;
    }

    public void setFormField(boolean state) {
        this.isFormField = state;
    }

    public OutputStream getOutputStream() throws IOException {
        if (this.mos == null) {
            this.mos = new InMemoryOutputStream(this.sizeThreshold);
        }
        return this.mos;
    }

    public String toString() {
        return "name=" + this.getName() + ", size=" + this.getSize() + "bytes, isFormField=" + this.isFormField() + ", FieldName=" + this.getFieldName();
    }

    private void writeObject(@NonNull ObjectOutputStream out) throws IOException {
        this.cachedContent = this.get();
        out.defaultWriteObject();
    }

    private void readObject(@NonNull ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        OutputStream output = this.getOutputStream();
        if (this.cachedContent != null) {
            output.write(this.cachedContent);
        }
        output.close();
        this.cachedContent = null;
    }

    public FileItemHeaders getHeaders() {
        return this.headers;
    }

    public void setHeaders(FileItemHeaders pHeaders) {
        this.headers = pHeaders;
    }
}

