/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.web.support.multipart.inmemory;

import com.aspectran.core.activity.request.FileParameter;
import com.aspectran.utils.FilenameUtils;
import com.aspectran.utils.annotation.jsr305.NonNull;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileUploadException;

public class InMemoryMultipartFileParameter
extends FileParameter {
    private FileItem fileItem;

    public InMemoryMultipartFileParameter(FileItem fileItem) {
        this.fileItem = fileItem;
    }

    @Override
    public File getFile() {
        return null;
    }

    @Override
    public String getContentType() {
        return this.fileItem.getContentType();
    }

    @Override
    public String getFileName() {
        return this.getCanonicalName(this.fileItem.getName());
    }

    @Override
    public long getFileSize() {
        return this.fileItem.getSize();
    }

    @Override
    public InputStream getInputStream() throws IOException {
        InputStream inputStream = this.fileItem.getInputStream();
        return inputStream != null ? inputStream : new ByteArrayInputStream(new byte[0]);
    }

    @Override
    public byte[] getBytes() {
        byte[] bytes = this.fileItem.get();
        return bytes != null ? bytes : new byte[]{};
    }

    @Override
    public File saveAs(File destFile, boolean overwrite) throws IOException {
        if (destFile == null) {
            throw new IllegalArgumentException("destFile can not be null");
        }
        destFile = this.determineDestinationFile(destFile, overwrite);
        try {
            this.fileItem.write(destFile);
        }
        catch (FileUploadException e) {
            throw new IllegalStateException(e.getMessage());
        }
        catch (Exception e) {
            throw new IOException("Could not save as file " + String.valueOf(destFile), e);
        }
        this.setSavedFile(destFile);
        return destFile;
    }

    @Override
    public File renameTo(File destFile, boolean overwrite) {
        throw new IllegalStateException("Can not rename because it is a file stored in memory");
    }

    @Override
    public void delete() {
        this.fileItem.delete();
    }

    @Override
    public void release() {
        if (this.fileItem != null) {
            this.fileItem = null;
        }
        this.releaseSavedFile();
    }

    @NonNull
    private String getCanonicalName(String filename) {
        return FilenameUtils.getName(filename);
    }

    public String getStorageDescription() {
        return "in memory";
    }
}

