/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.web.support.tags;

import com.aspectran.core.activity.Activity;
import com.aspectran.core.context.ActivityContext;
import com.aspectran.utils.Assert;
import com.aspectran.utils.annotation.jsr305.NonNull;
import com.aspectran.utils.annotation.jsr305.Nullable;
import com.aspectran.utils.logging.Logger;
import com.aspectran.utils.logging.LoggerFactory;
import com.aspectran.web.service.WebService;
import jakarta.servlet.jsp.JspException;
import jakarta.servlet.jsp.JspTagException;
import jakarta.servlet.jsp.tagext.TagSupport;
import jakarta.servlet.jsp.tagext.TryCatchFinally;

public abstract class CurrentActivityAwareTag
extends TagSupport
implements TryCatchFinally {
    private static final long serialVersionUID = 2941680793598183983L;
    protected final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    @Nullable
    private Activity currentActivity;

    public final int doStartTag() throws JspException {
        try {
            ActivityContext context = WebService.findActivityContext(this.pageContext.getRequest());
            Assert.state(context != null, "No current activity context found; WebService held in CoreServiceHolder?");
            this.currentActivity = context.getCurrentActivity();
            return this.doStartTagInternal();
        }
        catch (JspException | RuntimeException ex) {
            this.logger.error(ex.getMessage(), ex);
            throw ex;
        }
        catch (Exception ex) {
            this.logger.error(ex.getMessage(), ex);
            throw new JspTagException(ex.getMessage());
        }
    }

    @NonNull
    protected final Activity getCurrentActivity() {
        Assert.state(this.currentActivity != null, "No current activity set");
        return this.currentActivity;
    }

    protected abstract int doStartTagInternal() throws Exception;

    public void doCatch(@NonNull Throwable throwable) throws Throwable {
        throw throwable;
    }

    public void doFinally() {
        this.currentActivity = null;
    }
}

