/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.web.support.tags;

import com.aspectran.core.context.asel.value.ValueExpression;
import com.aspectran.utils.ToStringBuilder;
import com.aspectran.utils.annotation.jsr305.Nullable;
import com.aspectran.web.support.tags.HtmlEscapingAwareTag;
import com.aspectran.web.support.util.JavaScriptUtils;
import com.aspectran.web.support.util.TagUtils;
import jakarta.servlet.jsp.JspException;
import jakarta.servlet.jsp.JspTagException;
import java.io.IOException;

public class EvalTag
extends HtmlEscapingAwareTag {
    private static final long serialVersionUID = -7537957372386484506L;
    @Nullable
    private String expression;
    @Nullable
    private String var;
    private int scope = 1;
    private boolean javaScriptEscape;

    public void setExpression(@Nullable String expression) {
        this.expression = expression;
    }

    public void setVar(@Nullable String var) {
        this.var = var;
    }

    public void setScope(String scope) {
        this.scope = TagUtils.getScope(scope);
    }

    public void setJavaScriptEscape(boolean javaScriptEscape) {
        this.javaScriptEscape = javaScriptEscape;
    }

    @Override
    public int doStartTagInternal() throws JspException {
        return 1;
    }

    public int doEndTag() throws JspException {
        try {
            if (this.var != null) {
                Object value = ValueExpression.evaluate(this.expression, this.getCurrentActivity());
                this.pageContext.setAttribute(this.var, value, this.scope);
            } else {
                try {
                    Object value = ValueExpression.evaluate(this.expression, this.getCurrentActivity());
                    if (value != null) {
                        String str = ToStringBuilder.toString(value, this.getCurrentActivity().getStringifyContext());
                        str = this.htmlEscape(str);
                        if (this.javaScriptEscape) {
                            str = JavaScriptUtils.javaScriptEscape(str);
                        }
                        this.pageContext.getOut().print(str);
                    }
                }
                catch (IOException ex) {
                    throw new JspException((Throwable)ex);
                }
            }
            return 6;
        }
        catch (Exception ex) {
            throw new JspTagException(ex.getMessage(), (Throwable)ex);
        }
    }
}

