/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.web.support.tags;

import com.aspectran.core.adapter.ResponseAdapter;
import com.aspectran.utils.annotation.jsr305.Nullable;
import com.aspectran.web.support.tags.CurrentActivityAwareTag;
import com.aspectran.web.support.util.HtmlUtils;

public abstract class HtmlEscapingAwareTag
extends CurrentActivityAwareTag {
    private static final long serialVersionUID = 1853699535371633474L;
    @Nullable
    private Boolean htmlEscape;

    public void setHtmlEscape(boolean htmlEscape) {
        this.htmlEscape = htmlEscape;
    }

    protected boolean isHtmlEscape() {
        if (this.htmlEscape != null) {
            return this.htmlEscape;
        }
        return this.isDefaultHtmlEscape();
    }

    protected boolean isDefaultHtmlEscape() {
        Object value = this.getCurrentActivity().getSetting("defaultHtmlEscape");
        if (value == null) {
            return false;
        }
        if (value instanceof Boolean) {
            Boolean bool = (Boolean)value;
            return bool;
        }
        return Boolean.parseBoolean(value.toString());
    }

    protected String htmlEscape(String content) {
        String out = content;
        if (this.isHtmlEscape()) {
            String encoding = this.getCharacterEncoding();
            out = encoding != null ? HtmlUtils.htmlEscape(content, encoding) : HtmlUtils.htmlEscape(content);
        }
        return out;
    }

    private String getCharacterEncoding() {
        String encoding = null;
        ResponseAdapter responseAdapter = this.getCurrentActivity().getResponseAdapter();
        if (responseAdapter.getEncoding() == null) {
            encoding = this.getCurrentActivity().getTranslet().getDefinitiveResponseEncoding();
        }
        return encoding;
    }
}

