/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.web.support.tags;

import com.aspectran.utils.Assert;
import com.aspectran.utils.StringUtils;
import com.aspectran.utils.annotation.jsr305.NonNull;
import com.aspectran.utils.annotation.jsr305.Nullable;
import com.aspectran.web.support.tags.HtmlEscapingAwareTag;
import com.aspectran.web.support.tags.Param;
import com.aspectran.web.support.tags.ParamAware;
import com.aspectran.web.support.util.JavaScriptUtils;
import com.aspectran.web.support.util.TagUtils;
import com.aspectran.web.support.util.UriUtils;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.jsp.JspException;
import java.io.IOException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class UrlTag
extends HtmlEscapingAwareTag
implements ParamAware {
    private static final long serialVersionUID = 3862041218569310417L;
    private static final String URL_TEMPLATE_DELIMITER_PREFIX = "{";
    private static final String URL_TEMPLATE_DELIMITER_SUFFIX = "}";
    private static final String URL_TYPE_ABSOLUTE = "://";
    private List<Param> params = Collections.emptyList();
    private Set<String> templateParams = Collections.emptySet();
    @Nullable
    private UrlType type;
    private String value;
    @Nullable
    private String context;
    @Nullable
    private String var;
    private int scope = 1;
    private boolean javaScriptEscape = false;

    public void setValue(@NonNull String value) {
        if (value.contains(URL_TYPE_ABSOLUTE)) {
            this.type = UrlType.ABSOLUTE;
            this.value = value;
        } else if (value.startsWith("/")) {
            this.type = UrlType.CONTEXT_RELATIVE;
            this.value = value;
        } else {
            this.type = UrlType.RELATIVE;
            this.value = value;
        }
    }

    public void setContext(@NonNull String context) {
        this.context = context.startsWith("/") ? context : "/" + context;
    }

    public void setVar(@Nullable String var) {
        this.var = var;
    }

    public void setScope(String scope) {
        this.scope = TagUtils.getScope(scope);
    }

    public void setJavaScriptEscape(boolean javaScriptEscape) throws JspException {
        this.javaScriptEscape = javaScriptEscape;
    }

    @Override
    public void addParam(Param param) {
        this.params.add(param);
    }

    @Override
    public int doStartTagInternal() throws JspException {
        this.params = new ArrayList<Param>();
        this.templateParams = new HashSet<String>();
        return 1;
    }

    public int doEndTag() throws JspException {
        String url = this.createUrl();
        if (this.var == null) {
            try {
                this.pageContext.getOut().print(url);
            }
            catch (IOException ex) {
                throw new JspException((Throwable)ex);
            }
        } else {
            this.pageContext.setAttribute(this.var, (Object)url, this.scope);
        }
        return 6;
    }

    private String createUrl() throws JspException {
        Assert.state(this.value != null, "No value set");
        StringBuilder url = new StringBuilder();
        if (this.type == UrlType.CONTEXT_RELATIVE) {
            if (this.context == null) {
                String contextPath = this.getCurrentActivity().getReverseContextPath();
                if (StringUtils.hasLength(contextPath)) {
                    url.append(contextPath);
                }
            } else if (this.context.endsWith("/")) {
                url.append(this.context, 0, this.context.length() - 1);
            } else {
                url.append(this.context);
            }
        }
        if (this.type != UrlType.RELATIVE && this.type != UrlType.ABSOLUTE && !this.value.startsWith("/")) {
            url.append('/');
        }
        url.append(this.replaceUriTemplateParams(this.value, this.params, this.templateParams));
        url.append(this.createQueryString(this.params, this.templateParams, url.indexOf("?") == -1));
        String urlStr = url.toString();
        if (this.type != UrlType.ABSOLUTE) {
            HttpServletResponse response = (HttpServletResponse)this.pageContext.getResponse();
            urlStr = response.encodeURL(urlStr);
        }
        urlStr = this.htmlEscape(urlStr);
        urlStr = this.javaScriptEscape ? JavaScriptUtils.javaScriptEscape(urlStr) : urlStr;
        return urlStr;
    }

    @NonNull
    private String createQueryString(@NonNull List<Param> params, Set<String> usedParams, boolean includeQueryStringDelimiter) throws JspException {
        String encoding = this.pageContext.getResponse().getCharacterEncoding();
        StringBuilder qs = new StringBuilder();
        for (Param param : params) {
            if (usedParams.contains(param.getName()) || !StringUtils.hasLength(param.getName())) continue;
            if (includeQueryStringDelimiter && qs.isEmpty()) {
                qs.append('?');
            } else {
                qs.append('&');
            }
            try {
                qs.append(UriUtils.encodeQueryParam(param.getName(), encoding));
                if (param.getValue() == null) continue;
                qs.append('=');
                qs.append(UriUtils.encodeQueryParam(param.getValue(), encoding));
            }
            catch (UnsupportedCharsetException ex) {
                throw new JspException((Throwable)ex);
            }
        }
        return qs.toString();
    }

    private String replaceUriTemplateParams(@NonNull String uri, @NonNull List<Param> params, Set<String> usedParams) throws JspException {
        String encoding = this.pageContext.getResponse().getCharacterEncoding();
        for (Param param : params) {
            String value;
            String template = URL_TEMPLATE_DELIMITER_PREFIX + param.getName() + URL_TEMPLATE_DELIMITER_SUFFIX;
            if (uri.contains(template)) {
                usedParams.add(param.getName());
                value = param.getValue();
                try {
                    uri = StringUtils.replace(uri, template, value != null ? UriUtils.encodePath(value, encoding) : "");
                    continue;
                }
                catch (UnsupportedCharsetException ex) {
                    throw new JspException((Throwable)ex);
                }
            }
            template = "{/" + param.getName() + URL_TEMPLATE_DELIMITER_SUFFIX;
            if (!uri.contains(template)) continue;
            usedParams.add(param.getName());
            value = param.getValue();
            try {
                uri = StringUtils.replace(uri, template, value != null ? UriUtils.encodePathSegment(value, encoding) : "");
            }
            catch (UnsupportedCharsetException ex) {
                throw new JspException((Throwable)ex);
            }
        }
        return uri;
    }

    private static enum UrlType {
        CONTEXT_RELATIVE,
        RELATIVE,
        ABSOLUTE;

    }
}

