/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.web.support.util;

import com.aspectran.utils.Assert;
import com.aspectran.utils.annotation.jsr305.Nullable;
import com.aspectran.utils.logging.Logger;
import com.aspectran.utils.logging.LoggerFactory;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletResponse;

public class CookieGenerator {
    private static final Logger logger = LoggerFactory.getLogger(CookieGenerator.class);
    public static final String DEFAULT_COOKIE_PATH = "/";
    @Nullable
    private String cookieName;
    @Nullable
    private String cookieDomain;
    private String cookiePath = "/";
    @Nullable
    private Integer cookieMaxAge;
    private boolean cookieSecure = false;
    private boolean cookieHttpOnly = false;

    public void setCookieName(@Nullable String cookieName) {
        this.cookieName = cookieName;
    }

    @Nullable
    public String getCookieName() {
        return this.cookieName;
    }

    public void setCookieDomain(@Nullable String cookieDomain) {
        this.cookieDomain = cookieDomain;
    }

    @Nullable
    public String getCookieDomain() {
        return this.cookieDomain;
    }

    public void setCookiePath(String cookiePath) {
        this.cookiePath = cookiePath;
    }

    public String getCookiePath() {
        return this.cookiePath;
    }

    public void setCookieMaxAge(@Nullable Integer cookieMaxAge) {
        this.cookieMaxAge = cookieMaxAge;
    }

    @Nullable
    public Integer getCookieMaxAge() {
        return this.cookieMaxAge;
    }

    public void setCookieSecure(boolean cookieSecure) {
        this.cookieSecure = cookieSecure;
    }

    public boolean isCookieSecure() {
        return this.cookieSecure;
    }

    public void setCookieHttpOnly(boolean cookieHttpOnly) {
        this.cookieHttpOnly = cookieHttpOnly;
    }

    public boolean isCookieHttpOnly() {
        return this.cookieHttpOnly;
    }

    public void addCookie(HttpServletResponse response, String cookieValue) {
        Assert.notNull((Object)response, "HttpServletResponse must not be null");
        Cookie cookie = this.createCookie(cookieValue);
        Integer maxAge = this.getCookieMaxAge();
        if (maxAge != null) {
            cookie.setMaxAge(maxAge.intValue());
        }
        if (this.isCookieSecure()) {
            cookie.setSecure(true);
        }
        if (this.isCookieHttpOnly()) {
            cookie.setHttpOnly(true);
        }
        response.addCookie(cookie);
        if (logger.isTraceEnabled()) {
            logger.trace("Added cookie [" + this.getCookieName() + "=" + cookieValue + "]");
        }
    }

    public void removeCookie(HttpServletResponse response) {
        Assert.notNull((Object)response, "HttpServletResponse must not be null");
        Cookie cookie = this.createCookie("");
        cookie.setMaxAge(0);
        if (this.isCookieSecure()) {
            cookie.setSecure(true);
        }
        if (this.isCookieHttpOnly()) {
            cookie.setHttpOnly(true);
        }
        response.addCookie(cookie);
        if (logger.isTraceEnabled()) {
            logger.trace("Removed cookie '" + this.getCookieName() + "'");
        }
    }

    protected Cookie createCookie(String cookieValue) {
        Cookie cookie = new Cookie(this.getCookieName(), cookieValue);
        if (this.getCookieDomain() != null) {
            cookie.setDomain(this.getCookieDomain());
        }
        cookie.setPath(this.getCookiePath());
        return cookie;
    }
}

