/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.web.support.util;

import com.aspectran.core.activity.Translet;
import com.aspectran.utils.StringUtils;
import com.aspectran.utils.annotation.jsr305.NonNull;
import com.aspectran.utils.annotation.jsr305.Nullable;
import java.io.IOException;

public class SendRedirectBasedOnXForwardedProtocol {
    private static final String SCHEME_DELIMITER = "://";

    public static void redirect(@NonNull Translet translet, String location) throws IOException {
        translet.redirect(SendRedirectBasedOnXForwardedProtocol.getLocation(translet, location));
    }

    public static String getLocation(Translet translet, String location) {
        String forwarded = SendRedirectBasedOnXForwardedProtocol.getLocationForwarded(translet, location);
        return forwarded != null ? forwarded : location;
    }

    @Nullable
    public static String getLocationForwarded(@NonNull Translet translet, String location) {
        String host;
        String xForwardedProtocol = translet.getRequestAdapter().getHeader("X-Forwarded-Proto");
        if (StringUtils.hasLength(xForwardedProtocol) && StringUtils.hasLength(host = translet.getRequestAdapter().getHeader("Host")) && !SendRedirectBasedOnXForwardedProtocol.isAbsoluteUrl(location)) {
            return xForwardedProtocol + SCHEME_DELIMITER + host + location;
        }
        return null;
    }

    private static boolean isAbsoluteUrl(String location) {
        return location != null && location.toLowerCase().startsWith("http") && location.contains(SCHEME_DELIMITER);
    }
}

