/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.web.support.util;

import com.aspectran.utils.Assert;
import com.aspectran.utils.LinkedMultiValueMap;
import com.aspectran.utils.MultiValueMap;
import com.aspectran.utils.StringUtils;
import com.aspectran.utils.annotation.jsr305.NonNull;
import com.aspectran.utils.annotation.jsr305.Nullable;
import java.io.ByteArrayOutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public abstract class UriUtils {
    public static String encodeScheme(String scheme, String encoding) {
        return UriUtils.encode(scheme, encoding, UriComponentsType.SCHEME);
    }

    public static String encodeScheme(String scheme, Charset charset) {
        return UriUtils.encode(scheme, charset, UriComponentsType.SCHEME);
    }

    public static String encodeAuthority(String authority, String encoding) {
        return UriUtils.encode(authority, encoding, UriComponentsType.AUTHORITY);
    }

    public static String encodeAuthority(String authority, Charset charset) {
        return UriUtils.encode(authority, charset, UriComponentsType.AUTHORITY);
    }

    public static String encodeUserInfo(String userInfo, String encoding) {
        return UriUtils.encode(userInfo, encoding, UriComponentsType.USER_INFO);
    }

    public static String encodeUserInfo(String userInfo, Charset charset) {
        return UriUtils.encode(userInfo, charset, UriComponentsType.USER_INFO);
    }

    public static String encodeHost(String host, String encoding) {
        return UriUtils.encode(host, encoding, UriComponentsType.HOST_IPV4);
    }

    public static String encodeHost(String host, Charset charset) {
        return UriUtils.encode(host, charset, UriComponentsType.HOST_IPV4);
    }

    public static String encodePort(String port, String encoding) {
        return UriUtils.encode(port, encoding, UriComponentsType.PORT);
    }

    public static String encodePort(String port, Charset charset) {
        return UriUtils.encode(port, charset, UriComponentsType.PORT);
    }

    public static String encodePath(String path, String encoding) {
        return UriUtils.encode(path, encoding, UriComponentsType.PATH);
    }

    public static String encodePath(String path, Charset charset) {
        return UriUtils.encode(path, charset, UriComponentsType.PATH);
    }

    public static String encodePathSegment(String segment, String encoding) {
        return UriUtils.encode(segment, encoding, UriComponentsType.PATH_SEGMENT);
    }

    public static String encodePathSegment(String segment, Charset charset) {
        return UriUtils.encode(segment, charset, UriComponentsType.PATH_SEGMENT);
    }

    public static String encodeQuery(String query, String encoding) {
        return UriUtils.encode(query, encoding, UriComponentsType.QUERY);
    }

    public static String encodeQuery(String query, Charset charset) {
        return UriUtils.encode(query, charset, UriComponentsType.QUERY);
    }

    public static String encodeQueryParam(String queryParam, String encoding) {
        return UriUtils.encode(queryParam, encoding, UriComponentsType.QUERY_PARAM);
    }

    public static String encodeQueryParam(String queryParam, Charset charset) {
        return UriUtils.encode(queryParam, charset, UriComponentsType.QUERY_PARAM);
    }

    @NonNull
    public static MultiValueMap<String, String> encodeQueryParams(@NonNull MultiValueMap<String, String> params) {
        Charset charset = StandardCharsets.UTF_8;
        LinkedMultiValueMap<String, String> result = new LinkedMultiValueMap<String, String>(params.size());
        for (Map.Entry entry : params.entrySet()) {
            for (String value : (List)entry.getValue()) {
                result.add(UriUtils.encodeQueryParam((String)entry.getKey(), charset), UriUtils.encodeQueryParam(value, charset));
            }
        }
        return result;
    }

    public static String encodeFragment(String fragment, String encoding) {
        return UriUtils.encode(fragment, encoding, UriComponentsType.FRAGMENT);
    }

    public static String encodeFragment(String fragment, Charset charset) {
        return UriUtils.encode(fragment, charset, UriComponentsType.FRAGMENT);
    }

    public static String encode(String source, String encoding) {
        return UriUtils.encode(source, encoding, UriComponentsType.URI);
    }

    public static String encode(String source, Charset charset) {
        return UriUtils.encode(source, charset, UriComponentsType.URI);
    }

    @NonNull
    public static Map<String, String> encodeUriVariables(@NonNull Map<String, ?> uriVariables) {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>((int)Math.ceil((double)uriVariables.size() / 0.75));
        uriVariables.forEach((key, value) -> {
            String stringValue = value != null ? value.toString() : "";
            result.put((String)key, UriUtils.encode(stringValue, StandardCharsets.UTF_8));
        });
        return result;
    }

    @NonNull
    public static Object[] encodeUriVariables(Object ... uriVariables) {
        return Arrays.stream(uriVariables).map(value -> {
            String stringValue = value != null ? value.toString() : "";
            return UriUtils.encode(stringValue, StandardCharsets.UTF_8);
        }).toArray();
    }

    private static String encode(String scheme, String encoding, UriComponentsType type) {
        return UriUtils.encodeUriComponent(scheme, encoding, type);
    }

    private static String encode(String scheme, Charset charset, UriComponentsType type) {
        return UriUtils.encodeUriComponent(scheme, charset, type);
    }

    private static String encodeUriComponent(String source, String encoding, UriComponentsType type) {
        return UriUtils.encodeUriComponent(source, Charset.forName(encoding), type);
    }

    private static String encodeUriComponent(String source, Charset charset, UriComponentsType type) {
        if (!StringUtils.hasLength(source)) {
            return source;
        }
        Assert.notNull((Object)charset, "Charset must not be null");
        Assert.notNull((Object)type, "Type must not be null");
        byte[] bytes = source.getBytes(charset);
        boolean original = true;
        for (byte b : bytes) {
            if (type.isAllowed(b)) continue;
            original = false;
            break;
        }
        if (original) {
            return source;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream(bytes.length);
        for (byte b : bytes) {
            if (type.isAllowed(b)) {
                baos.write(b);
                continue;
            }
            baos.write(37);
            char hex1 = Character.toUpperCase(Character.forDigit(b >> 4 & 0xF, 16));
            char hex2 = Character.toUpperCase(Character.forDigit(b & 0xF, 16));
            baos.write(hex1);
            baos.write(hex2);
        }
        return baos.toString(charset);
    }

    public static String decode(String source, String encoding) {
        return UriUtils.decode(source, Charset.forName(encoding));
    }

    public static String decode(@NonNull String source, Charset charset) {
        int length = source.length();
        if (length == 0) {
            return source;
        }
        Assert.notNull((Object)charset, "Charset must not be null");
        ByteArrayOutputStream baos = new ByteArrayOutputStream(length);
        boolean changed = false;
        for (int i = 0; i < length; ++i) {
            char ch = source.charAt(i);
            if (ch == '%') {
                if (i + 2 < length) {
                    char hex1 = source.charAt(i + 1);
                    char hex2 = source.charAt(i + 2);
                    int u = Character.digit(hex1, 16);
                    int l = Character.digit(hex2, 16);
                    if (u == -1 || l == -1) {
                        throw new IllegalArgumentException("Invalid encoded sequence \"" + source.substring(i) + "\"");
                    }
                    baos.write((char)((u << 4) + l));
                    i += 2;
                    changed = true;
                    continue;
                }
                throw new IllegalArgumentException("Invalid encoded sequence \"" + source.substring(i) + "\"");
            }
            baos.write(ch);
        }
        return changed ? baos.toString(charset) : source;
    }

    @Nullable
    public static String extractFileExtension(@NonNull String path) {
        int begin;
        int paramIndex;
        int extIndex;
        int end = path.indexOf(63);
        int fragmentIndex = path.indexOf(35);
        if (fragmentIndex != -1 && (end == -1 || fragmentIndex < end)) {
            end = fragmentIndex;
        }
        if (end == -1) {
            end = path.length();
        }
        if ((extIndex = path.lastIndexOf(46, end = (paramIndex = path.indexOf(59, begin = path.lastIndexOf(47, end) + 1)) != -1 && paramIndex < end ? paramIndex : end)) != -1 && extIndex >= begin) {
            return path.substring(extIndex + 1, end);
        }
        return null;
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    static enum UriComponentsType {
        SCHEME{

            @Override
            public boolean isAllowed(int c) {
                return this.isAlpha(c) || this.isDigit(c) || 43 == c || 45 == c || 46 == c;
            }
        }
        ,
        AUTHORITY{

            @Override
            public boolean isAllowed(int c) {
                return this.isUnreserved(c) || this.isSubDelimiter(c) || 58 == c || 64 == c;
            }
        }
        ,
        USER_INFO{

            @Override
            public boolean isAllowed(int c) {
                return this.isUnreserved(c) || this.isSubDelimiter(c) || 58 == c;
            }
        }
        ,
        HOST_IPV4{

            @Override
            public boolean isAllowed(int c) {
                return this.isUnreserved(c) || this.isSubDelimiter(c);
            }
        }
        ,
        HOST_IPV6{

            @Override
            public boolean isAllowed(int c) {
                return this.isUnreserved(c) || this.isSubDelimiter(c) || 91 == c || 93 == c || 58 == c;
            }
        }
        ,
        PORT{

            @Override
            public boolean isAllowed(int c) {
                return this.isDigit(c);
            }
        }
        ,
        PATH{

            @Override
            public boolean isAllowed(int c) {
                return this.isPchar(c) || 47 == c;
            }
        }
        ,
        PATH_SEGMENT{

            @Override
            public boolean isAllowed(int c) {
                return this.isPchar(c);
            }
        }
        ,
        QUERY{

            @Override
            public boolean isAllowed(int c) {
                return this.isPchar(c) || 47 == c || 63 == c;
            }
        }
        ,
        QUERY_PARAM{

            @Override
            public boolean isAllowed(int c) {
                if (61 == c || 38 == c) {
                    return false;
                }
                return this.isPchar(c) || 47 == c || 63 == c;
            }
        }
        ,
        FRAGMENT{

            @Override
            public boolean isAllowed(int c) {
                return this.isPchar(c) || 47 == c || 63 == c;
            }
        }
        ,
        URI{

            @Override
            public boolean isAllowed(int c) {
                return this.isUnreserved(c);
            }
        };


        public abstract boolean isAllowed(int var1);

        protected boolean isAlpha(int c) {
            return c >= 97 && c <= 122 || c >= 65 && c <= 90;
        }

        protected boolean isDigit(int c) {
            return c >= 48 && c <= 57;
        }

        protected boolean isGenericDelimiter(int c) {
            return 58 == c || 47 == c || 63 == c || 35 == c || 91 == c || 93 == c || 64 == c;
        }

        protected boolean isSubDelimiter(int c) {
            return 33 == c || 36 == c || 38 == c || 39 == c || 40 == c || 41 == c || 42 == c || 43 == c || 44 == c || 59 == c || 61 == c;
        }

        protected boolean isReserved(int c) {
            return this.isGenericDelimiter(c) || this.isSubDelimiter(c);
        }

        protected boolean isUnreserved(int c) {
            return this.isAlpha(c) || this.isDigit(c) || 45 == c || 46 == c || 95 == c || 126 == c;
        }

        protected boolean isPchar(int c) {
            return this.isUnreserved(c) || this.isSubDelimiter(c) || 58 == c || 64 == c;
        }
    }
}

