/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.web.support.util;

import com.aspectran.core.activity.Activity;
import com.aspectran.core.activity.Translet;
import com.aspectran.core.context.asel.item.ItemEvaluator;
import com.aspectran.core.context.rule.ItemRuleMap;
import com.aspectran.core.context.rule.RedirectRule;
import com.aspectran.utils.Assert;
import com.aspectran.utils.StringUtils;
import com.aspectran.utils.annotation.jsr305.NonNull;
import com.aspectran.utils.annotation.jsr305.Nullable;
import com.aspectran.web.activity.request.RequestHeaderParser;
import com.aspectran.web.support.http.HttpMediaTypeNotAcceptableException;
import com.aspectran.web.support.http.MediaType;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;

public abstract class WebUtils {
    public static final String ERROR_EXCEPTION_ATTRIBUTE = "jakarta.servlet.error.exception";
    private static final char QUESTION_CHAR = '?';
    private static final char AMPERSAND_CHAR = '&';
    private static final char EQUAL_CHAR = '=';

    @Nullable
    public static Cookie getCookie(HttpServletRequest request, String name) {
        Assert.notNull((Object)request, "Request must not be null");
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!name.equals(cookie.getName())) continue;
                return cookie;
            }
        }
        return null;
    }

    @Nullable
    public static Cookie getCookie(Translet translet, String name) {
        Assert.notNull((Object)translet, "Translet must not be null");
        HttpServletRequest request = (HttpServletRequest)translet.getRequestAdapter().getAdaptee();
        return WebUtils.getCookie(request, name);
    }

    public static boolean isAcceptContentTypes(Translet translet, MediaType ... contentTypes) {
        Assert.notNull((Object)translet, "Translet must not be null");
        Assert.notNull((Object)contentTypes, "contentTypes must not be null");
        try {
            List<MediaType> acceptContentTypes = RequestHeaderParser.resolveAcceptContentTypes(translet.getRequestAdapter());
            for (MediaType mediaType : contentTypes) {
                if (!mediaType.isPresentIn(acceptContentTypes)) continue;
                return true;
            }
        }
        catch (HttpMediaTypeNotAcceptableException httpMediaTypeNotAcceptableException) {
            // empty catch block
        }
        return false;
    }

    public static String getRelativePath(String contextPath, @NonNull String requestUri) {
        if (StringUtils.hasLength(contextPath)) {
            return requestUri.substring(contextPath.length());
        }
        return requestUri;
    }

    @Nullable
    public static String getReverseContextPath(@NonNull HttpServletRequest request, String defaultContextPath) {
        String forwardedPath = request.getHeader("X-Forwarded-Path");
        if (forwardedPath != null) {
            if (forwardedPath.equals("/")) {
                return "";
            }
            if (forwardedPath.endsWith("/")) {
                return forwardedPath.substring(0, forwardedPath.length() - 1);
            }
            return forwardedPath;
        }
        return defaultContextPath;
    }

    @NonNull
    public static String createRedirectPath(RedirectRule redirectRule, Activity activity) throws IOException {
        ItemEvaluator evaluator;
        Map<String, Object> valueMap;
        ItemRuleMap parameterItemRuleMap;
        if (redirectRule == null) {
            throw new IllegalArgumentException("redirectRule must not be null");
        }
        String path = redirectRule.getPath(activity);
        int questionPos = -1;
        StringBuilder sb = new StringBuilder(256);
        if (path != null) {
            String contextPath;
            if (path.startsWith("/") && StringUtils.hasLength(contextPath = activity.getReverseContextPath())) {
                sb.append(contextPath);
            }
            sb.append(path);
            questionPos = path.indexOf(63);
        }
        if ((parameterItemRuleMap = redirectRule.getParameterItemRuleMap()) != null && !parameterItemRuleMap.isEmpty() && (valueMap = (evaluator = activity.getItemEvaluator()).evaluate(parameterItemRuleMap)) != null && !valueMap.isEmpty()) {
            if (questionPos == -1) {
                sb.append('?');
            }
            String name = null;
            for (Map.Entry<String, Object> entry : valueMap.entrySet()) {
                String stringValue;
                if (name != null) {
                    sb.append('&');
                }
                name = entry.getKey();
                Object value = entry.getValue();
                String string = stringValue = value != null ? value.toString() : null;
                if (redirectRule.isExcludeEmptyParameters() && stringValue != null && !stringValue.isEmpty()) {
                    sb.append(name).append('=');
                } else if (redirectRule.isExcludeNullParameters() && stringValue != null) {
                    sb.append(name).append('=');
                } else {
                    sb.append(name).append('=');
                }
                if (stringValue == null) continue;
                String encoding = redirectRule.getEncoding();
                if (encoding == null) {
                    encoding = StandardCharsets.ISO_8859_1.name();
                }
                stringValue = URLEncoder.encode(stringValue, encoding);
                sb.append(stringValue);
            }
        }
        return sb.toString();
    }
}

