/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.web.support.view;

import com.aspectran.core.activity.Activity;
import com.aspectran.core.activity.process.result.ProcessResult;
import com.aspectran.core.activity.response.dispatch.AbstractViewDispatcher;
import com.aspectran.core.activity.response.dispatch.DispatchResponse;
import com.aspectran.core.activity.response.dispatch.ViewDispatcherException;
import com.aspectran.core.adapter.RequestAdapter;
import com.aspectran.core.adapter.ResponseAdapter;
import com.aspectran.core.context.rule.DispatchRule;
import com.aspectran.utils.ToStringBuilder;
import com.aspectran.utils.logging.Logger;
import com.aspectran.utils.logging.LoggerFactory;
import com.aspectran.web.activity.request.ActivityRequestWrapper;
import jakarta.servlet.RequestDispatcher;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletResponse;

public class JspTemplateViewDispatcher
extends AbstractViewDispatcher {
    private static final Logger logger = LoggerFactory.getLogger(JspTemplateViewDispatcher.class);
    private static final String DEFAULT_CONTENT_TYPE = "text/html;charset=ISO-8859-1";
    private String template;
    private String includePageKey;

    public void setTemplate(String template) {
        this.template = template;
    }

    public void setIncludePageKey(String includePageKey) {
        this.includePageKey = includePageKey;
    }

    @Override
    public void dispatch(Activity activity, DispatchRule dispatchRule) throws ViewDispatcherException {
        try {
            if (this.template == null) {
                throw new IllegalArgumentException("No specified template page");
            }
            if (this.includePageKey == null) {
                throw new IllegalArgumentException("No attribute name to specify the include page name");
            }
            String jspPath = this.resolveViewName(dispatchRule, activity);
            RequestAdapter requestAdapter = activity.getRequestAdapter();
            ResponseAdapter responseAdapter = activity.getResponseAdapter();
            requestAdapter.setAttribute(this.includePageKey, jspPath);
            String contentType = dispatchRule.getContentType();
            if (contentType == null) {
                contentType = this.getContentType();
            }
            if (contentType != null) {
                responseAdapter.setContentType(contentType);
            } else {
                responseAdapter.setContentType(DEFAULT_CONTENT_TYPE);
            }
            String encoding = dispatchRule.getEncoding();
            if (encoding == null && responseAdapter.getEncoding() == null) {
                encoding = activity.getTranslet().getDefinitiveResponseEncoding();
            }
            if (encoding != null) {
                responseAdapter.setEncoding(encoding);
            }
            ProcessResult processResult = activity.getProcessResult();
            DispatchResponse.saveAttributes(requestAdapter, processResult);
            HttpServletResponse response = (HttpServletResponse)responseAdapter.getAdaptee();
            if (response.isCommitted()) {
                response.reset();
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Dispatching to " + this.template + " for " + jspPath);
            }
            ActivityRequestWrapper requestWrapper = new ActivityRequestWrapper(activity.getRequestAdapter());
            RequestDispatcher requestDispatcher = requestWrapper.getRequestDispatcher(this.template);
            requestDispatcher.forward((ServletRequest)requestWrapper, (ServletResponse)response);
            if (response.getStatus() == 404) {
                logger.warn("Resource file [" + this.template + "] not found");
            }
        }
        catch (Exception e) {
            activity.setRaisedException(e);
            throw new ViewDispatcherException("Failed to dispatch to JSP " + dispatchRule.toString(this, null), e);
        }
    }

    @Override
    public String toString() {
        ToStringBuilder tsb = new ToStringBuilder();
        tsb.append("name", super.toString());
        tsb.append("defaultContentType", this.getContentType());
        tsb.append("prefix", this.getPrefix());
        tsb.append("suffix", this.getSuffix());
        tsb.append("template", this.template);
        tsb.append("includePageKey", this.includePageKey);
        return tsb.toString();
    }
}

