/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.web.support.view;

import com.aspectran.core.activity.Activity;
import com.aspectran.core.activity.process.result.ProcessResult;
import com.aspectran.core.activity.response.dispatch.AbstractViewDispatcher;
import com.aspectran.core.activity.response.dispatch.DispatchResponse;
import com.aspectran.core.activity.response.dispatch.ViewDispatcherException;
import com.aspectran.core.adapter.RequestAdapter;
import com.aspectran.core.adapter.ResponseAdapter;
import com.aspectran.core.context.rule.DispatchRule;
import com.aspectran.utils.logging.Logger;
import com.aspectran.utils.logging.LoggerFactory;
import com.aspectran.web.activity.request.ActivityRequestWrapper;
import jakarta.servlet.RequestDispatcher;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletResponse;

public class JspViewDispatcher
extends AbstractViewDispatcher {
    private static final Logger logger = LoggerFactory.getLogger(JspViewDispatcher.class);
    private static final String DEFAULT_CONTENT_TYPE = "text/html;charset=ISO-8859-1";

    @Override
    public void dispatch(Activity activity, DispatchRule dispatchRule) throws ViewDispatcherException {
        String jspPath = null;
        try {
            jspPath = this.resolveViewName(dispatchRule, activity);
            RequestAdapter requestAdapter = activity.getRequestAdapter();
            ResponseAdapter responseAdapter = activity.getResponseAdapter();
            String contentType = dispatchRule.getContentType();
            if (contentType == null) {
                contentType = this.getContentType();
            }
            if (contentType != null) {
                responseAdapter.setContentType(contentType);
            } else {
                responseAdapter.setContentType(DEFAULT_CONTENT_TYPE);
            }
            String encoding = dispatchRule.getEncoding();
            if (encoding == null && responseAdapter.getEncoding() == null) {
                encoding = activity.getTranslet().getDefinitiveResponseEncoding();
            }
            if (encoding != null) {
                responseAdapter.setEncoding(encoding);
            }
            ProcessResult processResult = activity.getProcessResult();
            DispatchResponse.saveAttributes(requestAdapter, processResult);
            HttpServletResponse response = (HttpServletResponse)responseAdapter.getAdaptee();
            if (response.isCommitted()) {
                response.reset();
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Dispatching to " + jspPath);
            }
            ActivityRequestWrapper requestWrapper = new ActivityRequestWrapper(activity.getRequestAdapter());
            RequestDispatcher requestDispatcher = requestWrapper.getRequestDispatcher(jspPath);
            requestDispatcher.forward((ServletRequest)requestWrapper, (ServletResponse)response);
            if (response.getStatus() == 404) {
                logger.warn("Resource file [" + jspPath + "] not found");
            }
        }
        catch (Exception e) {
            activity.setRaisedException(e);
            throw new ViewDispatcherException("Failed to dispatch to JSP " + dispatchRule.toString(this, jspPath), e);
        }
    }
}

