/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.web.websocket.jsr356;

import com.aspectran.core.context.ActivityContext;
import com.aspectran.core.service.CoreServiceHolder;
import com.aspectran.utils.logging.Logger;
import com.aspectran.utils.logging.LoggerFactory;
import jakarta.websocket.server.ServerEndpointConfig;

public class AspectranConfigurator
extends ServerEndpointConfig.Configurator {
    private static final Logger logger = LoggerFactory.getLogger(AspectranConfigurator.class);

    public <T> T getEndpointInstance(Class<T> endpointClass) throws InstantiationException {
        ActivityContext context = CoreServiceHolder.findActivityContext(endpointClass);
        if (context == null) {
            String message = "No WebService found for " + String.valueOf(endpointClass);
            logger.error(message);
            throw new IllegalStateException(message);
        }
        T endpoint = context.getBeanRegistry().getBean(endpointClass);
        if (logger.isTraceEnabled()) {
            logger.trace("Using @ServerEndpoint singleton " + String.valueOf(endpoint));
        }
        return endpoint;
    }
}

