/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.web.websocket.jsr356;

import com.aspectran.utils.Assert;
import com.aspectran.utils.annotation.jsr305.NonNull;
import com.aspectran.utils.annotation.jsr305.Nullable;
import com.aspectran.utils.logging.Logger;
import com.aspectran.utils.logging.LoggerFactory;
import com.aspectran.web.service.WebService;
import jakarta.websocket.DeploymentException;
import jakarta.websocket.server.ServerContainer;
import jakarta.websocket.server.ServerEndpoint;
import jakarta.websocket.server.ServerEndpointConfig;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class ServerEndpointExporter {
    private static final Logger logger = LoggerFactory.getLogger(ServerEndpointExporter.class);
    private final WebService webService;
    private final ServerContainer serverContainer;
    @Nullable
    private List<Class<?>> annotatedEndpointClasses;

    public ServerEndpointExporter(@NonNull WebService webService) {
        this.webService = webService;
        this.serverContainer = (ServerContainer)webService.getServletContext().getAttribute(ServerContainer.class.getName());
    }

    @Nullable
    public ServerContainer getServerContainer() {
        return this.serverContainer;
    }

    public boolean hasServerContainer() {
        return this.serverContainer != null;
    }

    public void setAnnotatedEndpointClasses(Class<?> ... annotatedEndpointClasses) {
        this.annotatedEndpointClasses = Arrays.asList(annotatedEndpointClasses);
    }

    public Set<Class<?>> registerEndpoints() {
        Assert.state(this.getServerContainer() != null, "jakarta.websocket.server.ServerContainer not available");
        LinkedHashSet endpointClasses = new LinkedHashSet();
        if (this.annotatedEndpointClasses != null) {
            endpointClasses.addAll(this.annotatedEndpointClasses);
        } else {
            endpointClasses.addAll(this.findServerEndpointClasses());
        }
        for (Class clazz : endpointClasses) {
            this.registerEndpoint(clazz);
        }
        ServerEndpointConfig[] endpointConfigs = this.findServerEndpointConfigs();
        if (endpointConfigs != null) {
            for (ServerEndpointConfig endpointConfig : endpointConfigs) {
                this.registerEndpoint(endpointConfig);
                endpointClasses.add(endpointConfig.getEndpointClass());
            }
        }
        return endpointClasses;
    }

    private void registerEndpoint(Class<?> endpointClass) {
        ServerContainer serverContainer = this.getServerContainer();
        Assert.state(serverContainer != null, "No ServerContainer found. Most likely the server's own WebSocket ServletContainerInitializer has not run yet.");
        try {
            if (logger.isDebugEnabled()) {
                logger.debug("Registering @ServerEndpoint: " + String.valueOf(endpointClass));
            }
            serverContainer.addEndpoint(endpointClass);
        }
        catch (DeploymentException ex) {
            throw new IllegalStateException("Failed to register @ServerEndpoint: " + String.valueOf(endpointClass), ex);
        }
    }

    private void registerEndpoint(ServerEndpointConfig endpointConfig) {
        ServerContainer serverContainer = this.getServerContainer();
        Assert.state(serverContainer != null, "No ServerContainer found");
        try {
            if (logger.isDebugEnabled()) {
                logger.debug("Registering ServerEndpointConfig: " + String.valueOf(endpointConfig));
            }
            serverContainer.addEndpoint(endpointConfig);
        }
        catch (DeploymentException ex) {
            throw new IllegalStateException("Failed to register ServerEndpointConfig: " + String.valueOf(endpointConfig), ex);
        }
    }

    private Collection<Class<?>> findServerEndpointClasses() {
        return this.webService.getActivityContext().getBeanRegistry().findConfigBeanClassesWithAnnotation(ServerEndpoint.class);
    }

    private ServerEndpointConfig[] findServerEndpointConfigs() {
        return this.webService.getActivityContext().getBeanRegistry().getBeansOfType(ServerEndpointConfig.class);
    }
}

