/*
 * Copyright (c) 2008-2019 The Aspectran Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.aspectran.core.support;

import com.aspectran.core.component.bean.ablility.FactoryBean;
import com.aspectran.core.component.bean.annotation.AvoidAdvice;
import com.aspectran.core.component.bean.aware.EnvironmentAware;
import com.aspectran.core.context.env.Environment;

/**
 * {@code BasePathFactoryBean} that returns the base path under which the application is running.
 * This can be used to reference the base path by declaring it as a bean in the Aspectran
 * configuration metadata.
 *
 * <p>Created: 2017. 1. 29.</p>
 */
@AvoidAdvice
public class BasePathFactoryBean implements EnvironmentAware, FactoryBean<String> {

    private String basePath;

    @Override
    public void setEnvironment(Environment environment) {
        this.basePath = environment.getBasePath();
    }

    @Override
    public String getObject() {
        return basePath;
    }

}
