/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.activity;

import com.aspectran.core.activity.Activity;
import com.aspectran.core.activity.ActivityTerminatedException;
import com.aspectran.core.adapter.ApplicationAdapter;
import com.aspectran.core.adapter.RequestAdapter;
import com.aspectran.core.adapter.ResponseAdapter;
import com.aspectran.core.adapter.SessionAdapter;
import com.aspectran.core.context.ActivityContext;
import com.aspectran.core.context.env.Environment;
import com.aspectran.core.util.ExceptionUtils;

public abstract class AbstractActivity
implements Activity {
    private final ActivityContext context;
    private boolean included;
    private Activity outerActivity;
    private SessionAdapter sessionAdapter;
    private RequestAdapter requestAdapter;
    private ResponseAdapter responseAdapter;
    private Throwable raisedException;

    protected AbstractActivity(ActivityContext context) {
        this.context = context;
    }

    @Override
    public ActivityContext getActivityContext() {
        return this.context;
    }

    @Override
    public Environment getEnvironment() {
        return this.context.getEnvironment();
    }

    protected Activity getCurrentActivity() {
        return this.context.getCurrentActivity();
    }

    protected void saveCurrentActivity() {
        this.context.setCurrentActivity(this);
    }

    protected void backupCurrentActivity() {
        this.outerActivity = this.getCurrentActivity();
    }

    protected void removeCurrentActivity() {
        if (this.outerActivity != null) {
            this.context.setCurrentActivity(this.outerActivity);
        } else {
            this.context.removeCurrentActivity();
        }
    }

    @Override
    public boolean isIncluded() {
        return this.included;
    }

    protected void setIncluded(boolean included) {
        this.included = included;
    }

    @Override
    public ApplicationAdapter getApplicationAdapter() {
        return this.getEnvironment().getApplicationAdapter();
    }

    @Override
    public SessionAdapter getSessionAdapter() {
        return this.sessionAdapter;
    }

    protected void setSessionAdapter(SessionAdapter sessionAdapter) {
        this.sessionAdapter = sessionAdapter;
    }

    @Override
    public RequestAdapter getRequestAdapter() {
        return this.requestAdapter;
    }

    protected void setRequestAdapter(RequestAdapter requestAdapter) {
        this.requestAdapter = requestAdapter;
    }

    @Override
    public ResponseAdapter getResponseAdapter() {
        return this.responseAdapter;
    }

    protected void setResponseAdapter(ResponseAdapter responseAdapter) {
        this.responseAdapter = responseAdapter;
    }

    @Override
    public boolean isExceptionRaised() {
        return this.raisedException != null;
    }

    @Override
    public Throwable getRaisedException() {
        return this.raisedException;
    }

    @Override
    public Throwable getRootCauseOfRaisedException() {
        return ExceptionUtils.getRootCause(this.raisedException);
    }

    @Override
    public void setRaisedException(Throwable raisedException) {
        if (this.raisedException == null) {
            this.raisedException = raisedException;
        }
    }

    @Override
    public void clearRaisedException() {
        this.raisedException = null;
    }

    @Override
    public <T> T getBean(String id) {
        return this.context.getBeanRegistry().getBean(id);
    }

    @Override
    public <T> T getBean(Class<T> requiredType) {
        return this.context.getBeanRegistry().getBean(requiredType);
    }

    @Override
    public <T> T getBean(String id, Class<T> requiredType) {
        return this.context.getBeanRegistry().getBean(id, requiredType);
    }

    @Override
    public <T> T getBean(Class<T> requiredType, String id) {
        return this.context.getBeanRegistry().getBean(requiredType, id);
    }

    @Override
    public <T> T getBeanForConfig(Class<T> requiredType) {
        return this.context.getBeanRegistry().getBeanForConfig(requiredType);
    }

    @Override
    public boolean containsBean(String id) {
        return this.context.getBeanRegistry().containsBean(id);
    }

    @Override
    public boolean containsBean(Class<?> requiredType) {
        return this.context.getBeanRegistry().containsBean(requiredType);
    }

    @Override
    public void terminate() {
        this.terminate("Terminated by user code");
    }

    @Override
    public void terminate(String cause) {
        throw new ActivityTerminatedException(cause);
    }
}

