/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.activity;

import com.aspectran.core.activity.AbstractActivity;
import com.aspectran.core.activity.aspect.AdviceConstraintViolationException;
import com.aspectran.core.activity.aspect.AspectAdviceException;
import com.aspectran.core.activity.aspect.AspectAdviceResult;
import com.aspectran.core.activity.process.action.ActionExecutionException;
import com.aspectran.core.activity.process.action.Executable;
import com.aspectran.core.activity.process.result.ActionResult;
import com.aspectran.core.component.aspect.AspectAdviceRulePostRegister;
import com.aspectran.core.component.aspect.AspectAdviceRuleRegistry;
import com.aspectran.core.component.aspect.pointcut.Pointcut;
import com.aspectran.core.context.ActivityContext;
import com.aspectran.core.context.expr.TokenEvaluator;
import com.aspectran.core.context.rule.AspectAdviceRule;
import com.aspectran.core.context.rule.AspectRule;
import com.aspectran.core.context.rule.ExceptionRule;
import com.aspectran.core.context.rule.ExceptionThrownRule;
import com.aspectran.core.context.rule.SettingsAdviceRule;
import com.aspectran.core.context.rule.TransletRule;
import com.aspectran.core.context.rule.type.ActionType;
import com.aspectran.core.context.rule.type.AspectAdviceType;
import com.aspectran.core.context.rule.type.JoinpointTargetType;
import com.aspectran.core.context.rule.type.MethodType;
import com.aspectran.core.util.logging.Log;
import com.aspectran.core.util.logging.LogFactory;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class AdviceActivity
extends AbstractActivity {
    private static final Log log = LogFactory.getLog(AdviceActivity.class);
    private AspectAdviceRuleRegistry aspectAdviceRuleRegistry;
    private Set<AspectRule> relevantAspectRules;
    private AspectAdviceType currentAspectAdviceType;
    private AspectAdviceRule currentAspectAdviceRule;
    private Set<AspectAdviceRule> executedAspectAdviceRules;
    private AspectAdviceResult aspectAdviceResult;

    public AdviceActivity(ActivityContext context) {
        super(context);
    }

    protected void prepareAspectAdviceRule(TransletRule transletRule, boolean merge) {
        AspectAdviceRuleRegistry aarr;
        if (transletRule.hasPathVariables()) {
            AspectAdviceRulePostRegister postRegister = new AspectAdviceRulePostRegister();
            for (AspectRule aspectRule : this.getActivityContext().getAspectRuleRegistry().getAspectRules()) {
                Pointcut pointcut;
                JoinpointTargetType joinpointTargetType = aspectRule.getJoinpointTargetType();
                if (aspectRule.isBeanRelevant() || joinpointTargetType != JoinpointTargetType.TRANSLET || !this.isAcceptable(aspectRule) || (pointcut = aspectRule.getPointcut()) != null && !pointcut.matches(transletRule.getName())) continue;
                if (log.isDebugEnabled()) {
                    log.debug("Aspect " + aspectRule);
                }
                postRegister.register(aspectRule);
            }
            aarr = postRegister.getAspectAdviceRuleRegistry();
        } else {
            aarr = transletRule.replicateAspectAdviceRuleRegistry();
        }
        if (merge && aarr != null && this.aspectAdviceRuleRegistry != null) {
            this.aspectAdviceRuleRegistry.merge(aarr);
        } else {
            this.aspectAdviceRuleRegistry = aarr;
        }
    }

    @Override
    public void registerAspectRule(AspectRule aspectRule) {
        block15: {
            List<AspectAdviceRule> aspectAdviceRuleList;
            if (this.currentAspectAdviceType == null) {
                AdviceConstraintViolationException ex = new AdviceConstraintViolationException();
                String msg = "Advice can not be registered at an UNKNOWN activity phase";
                msg = ex.addViolation(aspectRule, msg);
                log.error(msg);
                throw ex;
            }
            if (this.currentAspectAdviceType == AspectAdviceType.THROWN) {
                AdviceConstraintViolationException ex = new AdviceConstraintViolationException();
                String msg = "Advice can not be registered at the THROWN activity phase";
                msg = ex.addViolation(aspectRule, msg);
                log.error(msg);
                throw ex;
            }
            if (this.relevantAspectRules != null && this.relevantAspectRules.contains(aspectRule)) {
                return;
            }
            if (!this.isAcceptable(aspectRule)) {
                return;
            }
            this.touchRelevantAspectRules().add(aspectRule);
            if (log.isDebugEnabled()) {
                log.debug("Aspect " + aspectRule);
            }
            if ((aspectAdviceRuleList = aspectRule.getAspectAdviceRuleList()) == null) break block15;
            if (this.currentAspectAdviceType == AspectAdviceType.FINALLY) {
                AdviceConstraintViolationException ex = null;
                for (AspectAdviceRule aspectAdviceRule : aspectAdviceRuleList) {
                    AspectAdviceType aspectAdviceType = aspectAdviceRule.getAspectAdviceType();
                    if (aspectAdviceType != AspectAdviceType.BEFORE && aspectAdviceType != AspectAdviceType.AFTER) continue;
                    if (ex == null) {
                        ex = new AdviceConstraintViolationException();
                    }
                    String msg = "BEFORE or AFTER advice should never be registered after the FINALLY activity phase";
                    if ((msg = ex.addViolation(aspectRule, msg)) == null) continue;
                    log.error(msg);
                }
                if (ex != null) {
                    throw ex;
                }
            }
            this.touchAspectAdviceRuleRegistry().register(aspectRule);
            if (this.currentAspectAdviceRule != null) {
                AspectAdviceRule adviceRule1 = this.currentAspectAdviceRule;
                AspectAdviceType adviceType1 = adviceRule1.getAspectAdviceType();
                for (AspectAdviceRule adviceRule2 : aspectAdviceRuleList) {
                    AspectAdviceType adviceType2 = adviceRule2.getAspectAdviceType();
                    if (adviceType1 == adviceType2) {
                        int order1 = adviceRule1.getAspectRule().getOrder();
                        int order2 = adviceRule2.getAspectRule().getOrder();
                        if (adviceType1 == AspectAdviceType.BEFORE) {
                            if (order2 >= order1) continue;
                            this.executeAdvice(adviceRule2, true);
                            continue;
                        }
                        if (order2 <= order1) continue;
                        this.executeAdvice(adviceRule2, true);
                        continue;
                    }
                    if (adviceType2 != AspectAdviceType.BEFORE) continue;
                    this.executeAdvice(adviceRule2, true);
                }
            } else {
                for (AspectAdviceRule aspectAdviceRule : aspectAdviceRuleList) {
                    if (aspectAdviceRule.getAspectAdviceType() != AspectAdviceType.BEFORE) continue;
                    this.executeAdvice(aspectAdviceRule, true);
                }
            }
        }
    }

    @Override
    public void registerSettingsAdviceRule(SettingsAdviceRule settingsAdviceRule) {
        if (this.relevantAspectRules != null && this.relevantAspectRules.contains(settingsAdviceRule.getAspectRule())) {
            return;
        }
        this.touchRelevantAspectRules().add(settingsAdviceRule.getAspectRule());
        this.touchAspectAdviceRuleRegistry().addAspectAdviceRule(settingsAdviceRule);
    }

    private boolean isAcceptable(AspectRule aspectRule) {
        MethodType requestMethod;
        if (!(aspectRule.getMethods() == null || (requestMethod = this.getTranslet().getRequestMethod()) != null && requestMethod.containsTo(aspectRule.getMethods()))) {
            return false;
        }
        if (aspectRule.getHeaders() != null) {
            boolean contained = false;
            for (String header : aspectRule.getHeaders()) {
                if (!this.getRequestAdapter().containsHeader(header)) continue;
                contained = true;
                break;
            }
            return contained;
        }
        return true;
    }

    private Set<AspectRule> touchRelevantAspectRules() {
        if (this.relevantAspectRules == null) {
            this.relevantAspectRules = new HashSet<AspectRule>();
        }
        return this.relevantAspectRules;
    }

    protected void setCurrentAspectAdviceType(AspectAdviceType aspectAdviceType) {
        this.currentAspectAdviceType = aspectAdviceType;
    }

    protected void executeAdvice(Executable action) {
        if (log.isDebugEnabled()) {
            log.debug("Action " + action);
        }
        try {
            action.execute(this);
        }
        catch (Exception e) {
            this.setRaisedException(e);
            throw new ActionExecutionException("Failed to execute advice action " + action, (Throwable)e);
        }
    }

    @Override
    public void executeAdvice(List<AspectAdviceRule> aspectAdviceRuleList, boolean throwable) {
        if (aspectAdviceRuleList != null && !aspectAdviceRuleList.isEmpty()) {
            while (true) {
                AspectAdviceRule target = null;
                if (this.executedAspectAdviceRules == null) {
                    target = aspectAdviceRuleList.get(0);
                } else {
                    for (AspectAdviceRule aspectAdviceRule : aspectAdviceRuleList) {
                        if (this.executedAspectAdviceRules.contains(aspectAdviceRule)) continue;
                        target = aspectAdviceRule;
                        break;
                    }
                }
                if (target == null) break;
                this.executeAdvice(target, throwable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void executeAdvice(AspectAdviceRule aspectAdviceRule, boolean throwable) {
        if (aspectAdviceRule.getAspectRule().isDisabled()) {
            this.touchExecutedAspectAdviceRules().add(aspectAdviceRule);
            return;
        }
        if (this.isExceptionRaised() && aspectAdviceRule.getExceptionRule() != null) {
            try {
                this.handleException(aspectAdviceRule.getExceptionRule());
            }
            catch (Exception e) {
                if (aspectAdviceRule.getAspectRule().isIsolated()) {
                    log.error("Failed to execute isolated advice action " + aspectAdviceRule, e);
                }
                if (throwable) {
                    throw new AspectAdviceException("Failed to execute advice action " + aspectAdviceRule, aspectAdviceRule, e);
                }
                log.error("Failed to execute advice action " + aspectAdviceRule, e);
            }
        }
        this.touchExecutedAspectAdviceRules().add(aspectAdviceRule);
        Executable action = aspectAdviceRule.getExecutableAction();
        if (action != null) {
            AspectAdviceRule oldAspectAdviceRule = this.currentAspectAdviceRule;
            this.currentAspectAdviceRule = aspectAdviceRule;
            try {
                Object result;
                Object adviceBean;
                if (action.getActionType() == ActionType.BEAN_METHOD) {
                    if (aspectAdviceRule.getAdviceBeanId() != null && (adviceBean = this.getAspectAdviceBean(aspectAdviceRule.getAspectId())) == null) {
                        adviceBean = aspectAdviceRule.getAdviceBeanClass() != null ? this.getBean(aspectAdviceRule.getAdviceBeanClass()) : this.getBean(aspectAdviceRule.getAdviceBeanId());
                        this.putAspectAdviceBean(aspectAdviceRule.getAspectId(), adviceBean);
                    }
                } else if (action.getActionType() == ActionType.ANNOTATED_METHOD && (adviceBean = this.getAspectAdviceBean(aspectAdviceRule.getAspectId())) == null) {
                    adviceBean = this.getBeanForConfig(aspectAdviceRule.getAdviceBeanClass());
                    this.putAspectAdviceBean(aspectAdviceRule.getAspectId(), adviceBean);
                }
                if ((result = action.execute(this)) != null && result != ActionResult.NO_RESULT) {
                    this.putAdviceResult(aspectAdviceRule, result);
                    if (action.getActionType() == ActionType.ECHO) {
                        if (action.getActionId() != null) {
                            this.getRequestAdapter().setAttribute(action.getActionId(), result);
                        } else {
                            Map echos = (Map)result;
                            for (Map.Entry item : echos.entrySet()) {
                                this.getRequestAdapter().setAttribute((String)item.getKey(), item.getValue());
                            }
                        }
                    }
                }
            }
            catch (Exception e) {
                if (aspectAdviceRule.getAspectRule().isIsolated()) {
                    log.error("Failed to execute an isolated advice action " + aspectAdviceRule, e);
                } else {
                    this.setRaisedException(e);
                    if (throwable) {
                        throw new AspectAdviceException("Failed to execute an advice action " + aspectAdviceRule, aspectAdviceRule, e);
                    }
                    log.error("Failed to execute an advice action " + aspectAdviceRule, e);
                }
            }
            finally {
                this.currentAspectAdviceRule = oldAspectAdviceRule;
            }
        }
    }

    private Set<AspectAdviceRule> touchExecutedAspectAdviceRules() {
        if (this.executedAspectAdviceRules == null) {
            this.executedAspectAdviceRules = new HashSet<AspectAdviceRule>();
        }
        return this.executedAspectAdviceRules;
    }

    @Override
    public void handleException(List<ExceptionRule> exceptionRuleList) {
        if (exceptionRuleList != null) {
            for (ExceptionRule exceptionRule : exceptionRuleList) {
                this.handleException(exceptionRule);
            }
        }
    }

    protected void handleException(ExceptionRule exceptionRule) {
        Executable action;
        ExceptionThrownRule exceptionThrownRule;
        if (exceptionRule != null && (exceptionThrownRule = exceptionRule.getExceptionThrownRule(this.getRaisedException())) != null && (action = exceptionThrownRule.getAction()) != null) {
            this.executeAdvice(action);
        }
    }

    protected AspectAdviceRuleRegistry touchAspectAdviceRuleRegistry() {
        if (this.aspectAdviceRuleRegistry == null) {
            this.aspectAdviceRuleRegistry = new AspectAdviceRuleRegistry();
        }
        return this.aspectAdviceRuleRegistry;
    }

    protected List<AspectAdviceRule> getBeforeAdviceRuleList() {
        if (this.aspectAdviceRuleRegistry != null) {
            return this.aspectAdviceRuleRegistry.getBeforeAdviceRuleList();
        }
        return null;
    }

    protected List<AspectAdviceRule> getAfterAdviceRuleList() {
        if (this.aspectAdviceRuleRegistry != null) {
            return this.aspectAdviceRuleRegistry.getAfterAdviceRuleList();
        }
        return null;
    }

    protected List<AspectAdviceRule> getFinallyAdviceRuleList() {
        if (this.aspectAdviceRuleRegistry != null) {
            return this.aspectAdviceRuleRegistry.getFinallyAdviceRuleList();
        }
        return null;
    }

    protected List<ExceptionRule> getExceptionRuleList() {
        if (this.aspectAdviceRuleRegistry != null) {
            return this.aspectAdviceRuleRegistry.getExceptionRuleList();
        }
        return null;
    }

    @Override
    public <T> T getSetting(String settingName) {
        if (this.aspectAdviceRuleRegistry != null) {
            Object value = this.aspectAdviceRuleRegistry.getSetting(settingName);
            if (value instanceof String) {
                value = TokenEvaluator.evaluate((String)value, this);
            }
            return value;
        }
        return null;
    }

    @Override
    public <T> T getAspectAdviceBean(String aspectId) {
        return (T)(this.aspectAdviceResult != null ? this.aspectAdviceResult.getAspectAdviceBean(aspectId) : null);
    }

    protected void putAspectAdviceBean(String aspectId, Object adviceBean) {
        if (this.aspectAdviceResult == null) {
            this.aspectAdviceResult = new AspectAdviceResult();
        }
        this.aspectAdviceResult.putAspectAdviceBean(aspectId, adviceBean);
    }

    public <T> T getBeforeAdviceResult(String aspectId) {
        return (T)(this.aspectAdviceResult != null ? this.aspectAdviceResult.getBeforeAdviceResult(aspectId) : null);
    }

    public <T> T getAfterAdviceResult(String aspectId) {
        return (T)(this.aspectAdviceResult != null ? this.aspectAdviceResult.getAfterAdviceResult(aspectId) : null);
    }

    public <T> T getAroundAdviceResult(String aspectId) {
        return (T)(this.aspectAdviceResult != null ? this.aspectAdviceResult.getAroundAdviceResult(aspectId) : null);
    }

    public <T> T getFinallyAdviceResult(String aspectId) {
        return (T)(this.aspectAdviceResult != null ? this.aspectAdviceResult.getFinallyAdviceResult(aspectId) : null);
    }

    protected void putAdviceResult(AspectAdviceRule aspectAdviceRule, Object adviceActionResult) {
        if (this.aspectAdviceResult == null) {
            this.aspectAdviceResult = new AspectAdviceResult();
        }
        this.aspectAdviceResult.putAdviceResult(aspectAdviceRule, adviceActionResult);
    }
}

