/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.activity;

import com.aspectran.core.activity.Activity;
import com.aspectran.core.activity.ActivityPerformException;
import com.aspectran.core.activity.ActivityPrepareException;
import com.aspectran.core.activity.ActivityTerminatedException;
import com.aspectran.core.activity.AdapterException;
import com.aspectran.core.activity.AdviceActivity;
import com.aspectran.core.activity.CoreTranslet;
import com.aspectran.core.activity.Translet;
import com.aspectran.core.activity.TransletNotFoundException;
import com.aspectran.core.activity.process.ActionList;
import com.aspectran.core.activity.process.ContentList;
import com.aspectran.core.activity.process.action.ActionExecutionException;
import com.aspectran.core.activity.process.action.Executable;
import com.aspectran.core.activity.process.result.ActionResult;
import com.aspectran.core.activity.process.result.ContentResult;
import com.aspectran.core.activity.process.result.ProcessResult;
import com.aspectran.core.activity.request.MissingMandatoryParametersException;
import com.aspectran.core.activity.request.PathVariableMap;
import com.aspectran.core.activity.response.ForwardResponse;
import com.aspectran.core.activity.response.Response;
import com.aspectran.core.adapter.BasicSessionAdapter;
import com.aspectran.core.adapter.SessionAdapter;
import com.aspectran.core.component.bean.scope.RequestScope;
import com.aspectran.core.context.ActivityContext;
import com.aspectran.core.context.expr.BooleanExpression;
import com.aspectran.core.context.expr.ItemEvaluator;
import com.aspectran.core.context.expr.ItemExpression;
import com.aspectran.core.context.expr.token.Token;
import com.aspectran.core.context.rule.ChooseRule;
import com.aspectran.core.context.rule.ChooseRuleMap;
import com.aspectran.core.context.rule.ChooseWhenRule;
import com.aspectran.core.context.rule.ExceptionRule;
import com.aspectran.core.context.rule.ExceptionThrownRule;
import com.aspectran.core.context.rule.ForwardRule;
import com.aspectran.core.context.rule.IllegalRuleException;
import com.aspectran.core.context.rule.ItemRule;
import com.aspectran.core.context.rule.ItemRuleList;
import com.aspectran.core.context.rule.ItemRuleMap;
import com.aspectran.core.context.rule.RequestRule;
import com.aspectran.core.context.rule.ResponseRule;
import com.aspectran.core.context.rule.TransletRule;
import com.aspectran.core.context.rule.type.AspectAdviceType;
import com.aspectran.core.context.rule.type.MethodType;
import com.aspectran.core.context.rule.type.ResponseType;
import com.aspectran.core.context.rule.type.TokenType;
import com.aspectran.core.support.i18n.locale.LocaleResolver;
import com.aspectran.core.util.logging.Log;
import com.aspectran.core.util.logging.LogFactory;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;

public class CoreActivity
extends AdviceActivity {
    private static final Log log = LogFactory.getLog(CoreActivity.class);
    private CoreTranslet translet;
    private Response reservedResponse;
    private Response desiredResponse;
    private boolean committed;
    private Set<Integer> processedChooses;

    protected CoreActivity(ActivityContext context) {
        super(context);
    }

    @Override
    public void prepare(String requestName) {
        TransletRule transletRule = this.getTransletRule(requestName, MethodType.GET);
        if (transletRule == null) {
            throw new TransletNotFoundException(requestName);
        }
        this.prepare(requestName, MethodType.GET, transletRule, null);
    }

    @Override
    public void prepare(TransletRule transletRule) {
        this.prepare(transletRule.getName(), transletRule);
    }

    @Override
    public void prepare(String requestName, TransletRule transletRule) {
        this.prepare(requestName, MethodType.GET, transletRule, null);
    }

    @Override
    public void prepare(String requestName, String requestMethod) {
        this.prepare(requestName, MethodType.resolve(requestMethod));
    }

    @Override
    public void prepare(String requestName, MethodType requestMethod) {
        this.prepare(requestName, requestMethod, null);
    }

    private void prepare(String requestName, MethodType requestMethod, Translet parentTranslet) {
        TransletRule transletRule;
        if (requestMethod == null) {
            requestMethod = MethodType.GET;
        }
        if ((transletRule = this.getTransletRule(requestName, requestMethod)) == null) {
            throw new TransletNotFoundException(requestName);
        }
        this.prepare(requestName, requestMethod, transletRule, parentTranslet);
    }

    private void prepare(String requestName, MethodType requestMethod, TransletRule transletRule, Translet parentTranslet) {
        try {
            if (log.isDebugEnabled()) {
                log.debug("Translet " + transletRule);
            }
            this.newTranslet(requestMethod, requestName, transletRule, parentTranslet);
            if (parentTranslet == null) {
                if (this.isIncluded()) {
                    this.backupCurrentActivity();
                    this.saveCurrentActivity();
                } else {
                    this.saveCurrentActivity();
                }
                this.adapt();
            }
            this.prepareAspectAdviceRule(transletRule, parentTranslet != null);
            this.parseRequest();
            this.parsePathVariables();
            if (parentTranslet == null) {
                this.resolveLocale();
            }
        }
        catch (ActivityTerminatedException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ActivityPrepareException("Failed to prepare activity for translet " + transletRule, e);
        }
    }

    protected void adapt() throws AdapterException {
        SessionAdapter sessionAdapter = this.getSessionAdapter();
        if (sessionAdapter != null && sessionAdapter instanceof BasicSessionAdapter) {
            ((BasicSessionAdapter)sessionAdapter).sessionAccess();
        }
    }

    protected void release() {
        SessionAdapter sessionAdapter = this.getSessionAdapter();
        if (sessionAdapter != null && sessionAdapter instanceof BasicSessionAdapter) {
            ((BasicSessionAdapter)sessionAdapter).sessionComplete();
        }
    }

    @Override
    public void perform() {
        ForwardRule forwardRule = null;
        try {
            try {
                this.setCurrentAspectAdviceType(AspectAdviceType.BEFORE);
                this.executeAdvice(this.getBeforeAdviceRuleList(), true);
                if (!this.isResponseReserved()) {
                    this.produce();
                }
                if ((forwardRule = this.response()) != null) {
                    this.forward(forwardRule);
                    return;
                }
                this.setCurrentAspectAdviceType(AspectAdviceType.AFTER);
                this.executeAdvice(this.getAfterAdviceRuleList(), true);
            }
            catch (Exception e) {
                this.setRaisedException(e);
            }
            finally {
                if (forwardRule == null) {
                    this.setCurrentAspectAdviceType(AspectAdviceType.FINALLY);
                    this.executeAdvice(this.getFinallyAdviceRuleList(), false);
                }
            }
            if (this.isExceptionRaised()) {
                this.setCurrentAspectAdviceType(AspectAdviceType.THROWN);
                this.exception();
                this.response();
                if (this.isExceptionRaised()) {
                    throw this.getRootCauseOfRaisedException();
                }
            }
            this.setCurrentAspectAdviceType(null);
        }
        catch (ActivityTerminatedException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new ActivityPerformException("Failed to perform the activity", e);
        }
        finally {
            RequestScope requestScope;
            if (forwardRule == null && (requestScope = this.getRequestAdapter().getRequestScope(false)) != null) {
                requestScope.destroy();
            }
        }
    }

    private void produce() {
        ActionList actionList;
        Response res;
        ContentList contentList = this.getTransletRule().getContentList();
        if (contentList != null) {
            ProcessResult processResult = this.translet.getProcessResult();
            if (processResult == null) {
                processResult = new ProcessResult(contentList.size());
                processResult.setName(contentList.getName());
                processResult.setExplicit(contentList.isExplicit());
                this.translet.setProcessResult(processResult);
            }
            for (ActionList actionList2 : contentList) {
                this.execute(actionList2);
                if (!this.isResponseReserved()) continue;
                break;
            }
        }
        if ((res = this.getResponse()) != null && (actionList = res.getActionList()) != null) {
            this.execute(actionList);
        }
    }

    private ForwardRule response() {
        if (this.committed) {
            return null;
        }
        this.committed = true;
        Response res = this.getResponse();
        if (res != null) {
            res.commit(this);
            if (this.isExceptionRaised()) {
                this.clearRaisedException();
            }
            if (res.getResponseType() == ResponseType.FORWARD) {
                ForwardResponse forwardResponse = (ForwardResponse)res;
                return forwardResponse.getForwardRule();
            }
        }
        return null;
    }

    private void forward(ForwardRule forwardRule) {
        if (log.isDebugEnabled()) {
            log.debug("Forwarding from [" + this.translet.getRequestName() + "] to [" + forwardRule.getTransletName() + "]");
        }
        this.reserveResponse(null);
        this.committed = false;
        this.prepare(forwardRule.getTransletName(), forwardRule.getRequestMethod(), this.translet);
        this.perform();
    }

    private void exception() {
        this.reserveResponse(null);
        this.committed = false;
        if (this.getTransletRule().getExceptionRule() != null) {
            this.handleException(this.getTransletRule().getExceptionRule());
        }
        if (this.getExceptionRuleList() != null) {
            this.handleException(this.getExceptionRuleList());
        }
    }

    @Override
    public void finish() {
        try {
            this.release();
            if (this.getResponseAdapter() != null) {
                this.getResponseAdapter().flush();
            }
        }
        catch (Exception e) {
            log.error("An error was detected while finishing an activity", e);
        }
        finally {
            this.removeCurrentActivity();
        }
    }

    private Response getResponse() {
        Response res = this.reservedResponse;
        if (res == null && !this.isExceptionRaised()) {
            res = this.getDeclaredResponse();
        }
        return res;
    }

    protected void reserveResponse(Response response) {
        this.reservedResponse = response;
        if (response != null && !this.isExceptionRaised()) {
            this.desiredResponse = response;
        }
    }

    protected void reserveResponse() {
        if (this.reservedResponse != null) {
            this.reservedResponse = this.getDeclaredResponse();
        }
    }

    @Override
    public boolean isResponseReserved() {
        return this.reservedResponse != null;
    }

    protected Response getDesiredResponse() {
        return this.desiredResponse != null ? this.desiredResponse : this.getDeclaredResponse();
    }

    protected String resolveRequestEncoding() {
        String encoding = this.getRequestRule().getEncoding();
        if (encoding == null) {
            encoding = (String)this.getSetting("characterEncoding");
        }
        return encoding;
    }

    protected String resolveResponseEncoding() {
        String encoding = this.getRequestRule().getEncoding();
        if (encoding == null) {
            encoding = this.resolveRequestEncoding();
        }
        return encoding;
    }

    protected LocaleResolver resolveLocale() {
        LocaleResolver localeResolver = null;
        String localeResolverBeanId = (String)this.getSetting("localeResolver");
        if (localeResolverBeanId != null) {
            localeResolver = this.getBean(localeResolverBeanId, LocaleResolver.class);
            localeResolver.resolveLocale(this.getTranslet());
            localeResolver.resolveTimeZone(this.getTranslet());
        }
        return localeResolver;
    }

    protected void parseRequest() {
        this.parseDeclaredParameters();
        this.parseDeclaredAttributes();
    }

    protected void parseDeclaredParameters() {
        ItemRuleMap parameterItemRuleMap = this.getRequestRule().getParameterItemRuleMap();
        if (parameterItemRuleMap != null && !parameterItemRuleMap.isEmpty()) {
            ItemEvaluator evaluator = null;
            ArrayList missingItemRules = null;
            for (ItemRule itemRule : parameterItemRuleMap.values()) {
                String[] values;
                Token[] tokens = itemRule.getTokens();
                if (tokens != null) {
                    String[] oldValues;
                    if (evaluator == null) {
                        evaluator = new ItemExpression(this);
                    }
                    if ((values = evaluator.evaluateAsStringArray(itemRule)) != (oldValues = this.getRequestAdapter().getParameterValues(itemRule.getName()))) {
                        this.getRequestAdapter().setParameter(itemRule.getName(), values);
                    }
                }
                if (!itemRule.isMandatory() || (values = this.getRequestAdapter().getParameterValues(itemRule.getName())) != null) continue;
                if (missingItemRules == null) {
                    missingItemRules = new ItemRuleList();
                }
                missingItemRules.add(itemRule);
            }
            if (missingItemRules != null) {
                throw new MissingMandatoryParametersException((ItemRuleList)missingItemRules);
            }
        }
    }

    protected void parseDeclaredAttributes() {
        ItemRuleMap attributeItemRuleMap = this.getRequestRule().getAttributeItemRuleMap();
        if (attributeItemRuleMap != null && !attributeItemRuleMap.isEmpty()) {
            ItemExpression evaluator = new ItemExpression(this);
            for (ItemRule itemRule : attributeItemRuleMap.values()) {
                Object value = evaluator.evaluate(itemRule);
                this.getRequestAdapter().setAttribute(itemRule.getName(), value);
            }
        }
    }

    private void parsePathVariables() {
        PathVariableMap pathVariableMap;
        Token[] nameTokens = this.getTransletRule().getNameTokens();
        if (nameTokens != null && (nameTokens.length != 1 || nameTokens[0].getType() != TokenType.TEXT) && (pathVariableMap = PathVariableMap.parse(nameTokens, this.translet.getRequestName())) != null) {
            pathVariableMap.applyTo(this.translet);
        }
    }

    @Override
    public void handleException(ExceptionRule exceptionRule) {
        ExceptionThrownRule exceptionThrownRule = exceptionRule.getExceptionThrownRule(this.getRaisedException());
        if (exceptionThrownRule != null) {
            Executable action = exceptionThrownRule.getAction();
            if (action != null) {
                this.executeAdvice(action);
            }
            if (!this.isResponseReserved() && this.translet != null) {
                this.handleException(exceptionThrownRule);
            }
        }
    }

    private void handleException(ExceptionThrownRule exceptionThrownRule) {
        Response response = this.getDesiredResponse();
        String contentType = response != null ? response.getContentType() : null;
        Response targetResponse = exceptionThrownRule.getResponse(contentType);
        if (targetResponse != null) {
            this.translet.setProcessResult(null);
            ActionList actionList = targetResponse.getActionList();
            if (actionList != null) {
                this.execute(actionList);
            }
            this.reserveResponse(targetResponse);
        }
    }

    protected void execute(ActionList actionList) {
        ContentResult contentResult;
        ProcessResult processResult = this.translet.getProcessResult();
        if (processResult == null) {
            processResult = new ProcessResult(1);
            this.translet.setProcessResult(processResult);
        }
        if ((contentResult = processResult.getContentResult(actionList.getName(), actionList.isExplicit())) == null) {
            contentResult = new ContentResult(processResult, actionList.size());
            contentResult.setName(actionList.getName());
            if (!processResult.isExplicit()) {
                contentResult.setExplicit(actionList.isExplicit());
            }
        }
        for (Executable action : actionList) {
            this.execute(action, contentResult);
            if (!this.isResponseReserved()) continue;
            break;
        }
    }

    private void execute(Executable action, ContentResult contentResult) {
        try {
            ChooseWhenRule chooseWhenRule = null;
            if (action.getCaseNo() > 0) {
                ChooseRuleMap chooseRuleMap = this.getTransletRule().getChooseRuleMap();
                if (chooseRuleMap == null || chooseRuleMap.isEmpty()) {
                    throw new IllegalRuleException("No defined choose rules");
                }
                ChooseRule chooseRule = chooseRuleMap.getChooseRule(action.getCaseNo());
                if (chooseRule == null) {
                    throw new IllegalRuleException("No choose rule with case number: " + ChooseRule.toCaseGroupNo(action.getCaseNo()));
                }
                chooseWhenRule = chooseRule.getChooseWhenRule(action.getCaseNo());
                if (chooseWhenRule == null) {
                    throw new IllegalRuleException("No choose rule with case number: " + action.getCaseNo());
                }
                if (this.processedChooses != null && this.processedChooses.contains(chooseRule.getCaseNo())) {
                    return;
                }
                if (this.processedChooses == null || !this.processedChooses.contains(chooseWhenRule.getCaseNo())) {
                    BooleanExpression expression = new BooleanExpression(this);
                    if (expression.evaluate(chooseWhenRule)) {
                        if (this.processedChooses == null) {
                            this.processedChooses = new HashSet<Integer>();
                        }
                        this.processedChooses.add(chooseRule.getCaseNo());
                        this.processedChooses.add(chooseWhenRule.getCaseNo());
                    } else {
                        return;
                    }
                }
            }
            if (log.isDebugEnabled()) {
                log.debug("Action " + action);
            }
            Object resultValue = action.execute(this);
            if (!action.isHidden() && contentResult != null && resultValue != ActionResult.NO_RESULT) {
                if (resultValue instanceof ProcessResult) {
                    contentResult.addActionResult(action, (ProcessResult)resultValue);
                } else {
                    contentResult.addActionResult(action, resultValue);
                }
            }
            if (action.isLastInChooseWhen() && chooseWhenRule != null && chooseWhenRule.getResponse() != null) {
                this.reserveResponse(chooseWhenRule.getResponse());
            }
        }
        catch (ActionExecutionException e) {
            throw e;
        }
        catch (Exception e) {
            this.setRaisedException(e);
            throw new ActionExecutionException("Failed to execute action " + action, (Throwable)e);
        }
    }

    @Override
    public <T extends Activity> T newActivity() {
        throw new UnsupportedOperationException("newActivity");
    }

    private void newTranslet(MethodType requestMethod, String requestName, TransletRule transletRule, Translet parentTranslet) {
        this.translet = new CoreTranslet(transletRule, this);
        this.translet.setRequestName(requestName);
        this.translet.setRequestMethod(requestMethod);
        if (parentTranslet != null) {
            this.translet.setProcessResult(parentTranslet.getProcessResult());
        }
    }

    @Override
    public Translet getTranslet() {
        return this.translet;
    }

    @Override
    public ProcessResult getProcessResult() {
        return this.translet.getProcessResult();
    }

    @Override
    public Object getProcessResult(String actionId) {
        return this.translet.getProcessResult().getResultValue(actionId);
    }

    private TransletRule getTransletRule(String transletName, MethodType requestMethod) {
        return this.getActivityContext().getTransletRuleRegistry().getTransletRule(transletName, requestMethod);
    }

    protected TransletRule getTransletRule() {
        return this.translet.getTransletRule();
    }

    protected RequestRule getRequestRule() {
        return this.translet.getRequestRule();
    }

    protected ResponseRule getResponseRule() {
        return this.translet.getResponseRule();
    }

    @Override
    public Response getDeclaredResponse() {
        return this.getResponseRule() != null ? this.getResponseRule().getResponse() : null;
    }
}

