/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.activity.aspect;

import com.aspectran.core.activity.SessionScopeActivity;
import com.aspectran.core.activity.aspect.AdviceConstraintViolationException;
import com.aspectran.core.component.aspect.AspectAdviceRuleRegistry;
import com.aspectran.core.component.aspect.AspectRuleRegistry;
import com.aspectran.core.context.ActivityContext;
import com.aspectran.core.context.rule.AspectAdviceRule;
import com.aspectran.core.context.rule.ExceptionRule;
import com.aspectran.core.context.rule.ExceptionThrownRule;
import com.aspectran.core.util.logging.Log;
import com.aspectran.core.util.logging.LogFactory;
import java.util.List;

public class SessionScopeAdvisor {
    private static final Log log = LogFactory.getLog(SessionScopeAdvisor.class);
    private final SessionScopeActivity activity;
    private final List<AspectAdviceRule> beforeAdviceRuleList;
    private final List<AspectAdviceRule> afterAdviceRuleList;

    private SessionScopeAdvisor(SessionScopeActivity activity, AspectAdviceRuleRegistry aspectAdviceRuleRegistry) {
        this.activity = activity;
        this.beforeAdviceRuleList = aspectAdviceRuleRegistry.getBeforeAdviceRuleList();
        this.afterAdviceRuleList = aspectAdviceRuleRegistry.getAfterAdviceRuleList();
    }

    public SessionScopeActivity getSessionScopeActivity() {
        return this.activity;
    }

    public void executeBeforeAdvice() {
        if (this.beforeAdviceRuleList != null) {
            this.activity.executeAdvice(this.beforeAdviceRuleList, true);
        }
    }

    public void executeAfterAdvice() {
        if (this.afterAdviceRuleList != null) {
            this.activity.executeAdvice(this.afterAdviceRuleList, false);
        }
    }

    public static SessionScopeAdvisor create(ActivityContext context) {
        AspectRuleRegistry aspectRuleRegistry = context.getAspectRuleRegistry();
        AspectAdviceRuleRegistry aarr = aspectRuleRegistry.getSessionAspectAdviceRuleRegistry();
        if (aarr != null) {
            if (aarr.getFinallyAdviceRuleList() != null || aarr.getExceptionRuleList() != null) {
                AdviceConstraintViolationException ex = null;
                for (AspectAdviceRule aspectAdviceRule : aarr.getFinallyAdviceRuleList()) {
                    if (ex == null) {
                        ex = new AdviceConstraintViolationException();
                    }
                    Object msg = "FINALLY or THROWN Advice should not be applied in Session Scope";
                    msg = ex.addViolation(aspectAdviceRule.getAspectRule(), (String)msg);
                    if (msg == null) continue;
                    log.error((String)msg);
                }
                for (ExceptionRule exceptionRule : aarr.getExceptionRuleList()) {
                    if (exceptionRule.getExceptionThrownRuleMap() != null) {
                        for (ExceptionThrownRule exceptionThrownRule : exceptionRule.getExceptionThrownRuleMap().values()) {
                            if (exceptionThrownRule.getAspectAdviceRule() == null) continue;
                            if (ex == null) {
                                ex = new AdviceConstraintViolationException();
                            }
                            String msg = "FINALLY or THROWN Advice should not be applied in Session Scope";
                            msg = ex.addViolation(exceptionThrownRule.getAspectAdviceRule().getAspectRule(), msg);
                            if (msg == null) continue;
                            log.error(msg);
                        }
                    }
                    if (exceptionRule.getDefaultExceptionThrownRule() == null) continue;
                    ExceptionThrownRule exceptionThrownRule = exceptionRule.getDefaultExceptionThrownRule();
                    if (ex == null) {
                        ex = new AdviceConstraintViolationException();
                    }
                    String msg = "FINALLY or THROWN Advice should not be applied in Session Scope";
                    msg = ex.addViolation(exceptionThrownRule.getAspectAdviceRule().getAspectRule(), msg);
                    if (msg == null) continue;
                    log.error(msg);
                }
                if (ex != null) {
                    throw ex;
                }
            }
            SessionScopeActivity activity = new SessionScopeActivity(context);
            return new SessionScopeAdvisor(activity, aarr);
        }
        return null;
    }
}

