/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.activity.process.action;

import com.aspectran.core.activity.Activity;
import com.aspectran.core.activity.Translet;
import com.aspectran.core.activity.process.action.AbstractAction;
import com.aspectran.core.activity.process.action.ActionExecutionException;
import com.aspectran.core.activity.process.action.ParameterBindingException;
import com.aspectran.core.activity.request.ParameterMap;
import com.aspectran.core.component.bean.NoUniqueBeanException;
import com.aspectran.core.component.bean.annotation.Component;
import com.aspectran.core.component.bean.annotation.Format;
import com.aspectran.core.component.bean.annotation.Qualifier;
import com.aspectran.core.component.bean.annotation.Required;
import com.aspectran.core.context.rule.AnnotatedMethodActionRule;
import com.aspectran.core.context.rule.ParameterBindingRule;
import com.aspectran.core.context.rule.type.ActionType;
import com.aspectran.core.util.BeanDescriptor;
import com.aspectran.core.util.BeanUtils;
import com.aspectran.core.util.ClassUtils;
import com.aspectran.core.util.MethodUtils;
import com.aspectran.core.util.StringUtils;
import com.aspectran.core.util.ToStringBuilder;
import com.aspectran.core.util.logging.Log;
import com.aspectran.core.util.logging.LogFactory;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class AnnotatedMethodAction
extends AbstractAction {
    private static final Log log = LogFactory.getLog(AnnotatedMethodAction.class);
    private static final Object UNKNOWN_VALUE_TYPE = new Object();
    private final AnnotatedMethodActionRule annotatedMethodActionRule;

    public AnnotatedMethodAction(AnnotatedMethodActionRule annotatedMethodActionRule) {
        this.annotatedMethodActionRule = annotatedMethodActionRule;
    }

    @Override
    public Object execute(Activity activity) throws Exception {
        Object bean = null;
        try {
            if (!Modifier.isInterface(this.annotatedMethodActionRule.getBeanClass().getModifiers())) {
                bean = activity.getBeanForConfig(this.annotatedMethodActionRule.getBeanClass());
            }
            Method method = this.annotatedMethodActionRule.getMethod();
            ParameterBindingRule[] parameterBindingRules = this.annotatedMethodActionRule.getParameterBindingRules();
            return AnnotatedMethodAction.invokeMethod(activity, bean, method, parameterBindingRules);
        }
        catch (Exception e) {
            throw new ActionExecutionException("Failed to execute annotated bean method action " + this + " in bean " + bean, (Throwable)e);
        }
    }

    public AnnotatedMethodActionRule getAnnotatedMethodActionRule() {
        return this.annotatedMethodActionRule;
    }

    @Override
    public String getActionId() {
        return this.annotatedMethodActionRule.getActionId();
    }

    @Override
    public boolean isHidden() {
        return false;
    }

    @Override
    public ActionType getActionType() {
        return ActionType.ANNOTATED_METHOD;
    }

    @Override
    public <T> T getActionRule() {
        return (T)this.getAnnotatedMethodActionRule();
    }

    public String toString() {
        ToStringBuilder tsb = new ToStringBuilder();
        tsb.append("actionType", (Object)this.getActionType());
        tsb.append("annotatedMethodActionRule", this.annotatedMethodActionRule);
        return tsb.toString();
    }

    public static Object invokeMethod(Activity activity, Object bean, Method method, ParameterBindingRule[] parameterBindingRules) throws Exception {
        ParameterBindingRule parameterBindingRule = null;
        try {
            if (parameterBindingRules == null) {
                return method.invoke(bean, MethodUtils.EMPTY_OBJECT_ARRAY);
            }
            Translet translet = activity.getTranslet();
            Object[] args = new Object[parameterBindingRules.length];
            for (int i = 0; i < parameterBindingRules.length; ++i) {
                parameterBindingRule = parameterBindingRules[i];
                Class<?> type = parameterBindingRule.getType();
                String name = parameterBindingRule.getName();
                String format = parameterBindingRule.getFormat();
                boolean required = parameterBindingRule.isRequired();
                Exception thrown = null;
                try {
                    args[i] = AnnotatedMethodAction.parseArgument(translet, type, name, format);
                }
                catch (NumberFormatException e) {
                    thrown = e;
                    if (type.isPrimitive()) {
                        args[i] = 0;
                    }
                }
                catch (IllegalArgumentException e) {
                    throw e;
                }
                catch (Exception e) {
                    thrown = e;
                }
                if (thrown != null && log.isDebugEnabled()) {
                    log.debug("Invalid parameter '" + name + "'; Cause: " + thrown.getMessage(), thrown);
                }
                if (!required || args[i] != null && thrown == null) continue;
                if (thrown != null) {
                    throw new IllegalArgumentException("Missing required parameter '" + name + "'; Cause: " + thrown, thrown);
                }
                throw new IllegalArgumentException("Missing required parameter '" + name + "'");
            }
            parameterBindingRule = null;
            return method.invoke(bean, args);
        }
        catch (InvocationTargetException e) {
            if (e.getCause() != null) {
                throw (Exception)e.getCause();
            }
            throw e;
        }
        catch (Exception e) {
            if (parameterBindingRule != null) {
                throw new ParameterBindingException(parameterBindingRule, (Throwable)e);
            }
            throw e;
        }
    }

    private static Object parseArgument(Translet translet, Class<?> type, String name, String format) throws Exception {
        Object result = null;
        if (translet != null) {
            if (type == Translet.class) {
                result = translet;
            } else if (type.isArray()) {
                if ((type = type.getComponentType()) == Translet.class) {
                    result = new Translet[]{translet};
                } else {
                    String[] values = translet.getParameterValues(name);
                    result = AnnotatedMethodAction.parseArrayValues(type, values, format);
                    if (result == UNKNOWN_VALUE_TYPE) {
                        result = null;
                    }
                }
            } else if (type == ParameterMap.class) {
                ParameterMap parameterMap = new ParameterMap();
                for (String paramName : translet.getParameterNames()) {
                    parameterMap.setParameterValues(paramName, translet.getParameterValues(paramName));
                }
                result = parameterMap;
            } else if (Map.class.isAssignableFrom(type)) {
                if (!type.isInterface()) {
                    Map map = (Map)ClassUtils.createInstance(type);
                    map.putAll(translet.getAllParameters());
                    result = map;
                } else {
                    result = new HashMap<String, Object>(translet.getAllParameters());
                }
            } else if (Collection.class.isAssignableFrom(type)) {
                String[] values = translet.getParameterValues(name);
                if (!type.isInterface()) {
                    Collection collection = (Collection)ClassUtils.createInstance(type);
                    if (values != null) {
                        collection.addAll(Arrays.asList(values));
                    }
                    result = collection;
                } else {
                    result = values != null ? new ArrayList<String>(Arrays.asList(values)) : new ArrayList();
                }
            } else {
                String value = translet.getParameter(name);
                result = AnnotatedMethodAction.parseValue(type, value, format);
                if (result == UNKNOWN_VALUE_TYPE) {
                    if (type.isAnnotationPresent(Component.class)) {
                        try {
                            result = translet.getBean(type);
                        }
                        catch (NoUniqueBeanException e) {
                            result = translet.getBean(type, name);
                        }
                    } else {
                        result = AnnotatedMethodAction.parseModel((Translet)translet, type);
                    }
                }
            }
        }
        return result;
    }

    private static Object parseModel(Translet translet, Class<?> modelType) {
        Object model = ClassUtils.createInstance(modelType);
        BeanDescriptor bd = BeanDescriptor.getInstance(modelType);
        ArrayList<String> missingProperties = new ArrayList<String>();
        for (String name : bd.getWritablePropertyNames()) {
            try {
                Object val;
                String format;
                Method method = bd.getSetter(name);
                Class<?> type = bd.getSetterType(name);
                Qualifier qualifierAnno = bd.getSetterAnnotation(method, Qualifier.class);
                String paramName = qualifierAnno != null ? qualifierAnno.value() : name;
                Format formatAnno = bd.getSetterAnnotation(method, Format.class);
                String string = format = formatAnno != null ? formatAnno.value() : null;
                if (type.isArray()) {
                    type = type.getComponentType();
                    val = AnnotatedMethodAction.parseArrayValues(type, translet.getParameterValues(paramName), format);
                } else {
                    val = AnnotatedMethodAction.parseValue(type, translet.getParameter(paramName), format);
                }
                if (val != null && val != UNKNOWN_VALUE_TYPE) {
                    BeanUtils.setProperty(model, name, val);
                    continue;
                }
                if (!method.isAnnotationPresent(Required.class)) continue;
                missingProperties.add(name);
            }
            catch (Exception e) {
                if (!log.isDebugEnabled()) continue;
                log.debug(e.getMessage(), e);
            }
        }
        if (!missingProperties.isEmpty()) {
            String properties = StringUtils.joinCommaDelimitedList(missingProperties);
            throw new IllegalArgumentException("Missing required properties [" + properties + "] for " + modelType);
        }
        return model;
    }

    private static Object parseValue(Class<?> type, String value, String format) throws Exception {
        Object result = null;
        if (type == String.class) {
            result = value;
        } else if (type == Character.TYPE) {
            result = value != null && !value.isEmpty() ? Character.valueOf(value.charAt(0)) : Character.valueOf('\u0000');
        } else if (type == Character.class) {
            if (value != null && !value.isEmpty()) {
                result = Character.valueOf(value.charAt(0));
            }
        } else if (type == Date.class) {
            if (value != null) {
                result = new SimpleDateFormat(format).parse(value);
            }
        } else if (type == LocalDate.class) {
            if (value != null) {
                DateTimeFormatter formatter = DateTimeFormatter.ofPattern(format);
                result = LocalDate.parse(value, formatter);
            }
        } else if (type == LocalDateTime.class) {
            if (value != null) {
                DateTimeFormatter formatter = DateTimeFormatter.ofPattern(format);
                result = LocalDateTime.parse(value, formatter);
            }
        } else if (type == Boolean.TYPE) {
            result = Boolean.valueOf(value);
        } else if (type == Boolean.class) {
            if (value != null) {
                result = Boolean.valueOf(value);
            }
        } else if (type == Byte.TYPE) {
            result = value != null ? (Number)Byte.valueOf(value) : (Number)0;
        } else if (type == Byte.class) {
            if (value != null) {
                result = Byte.valueOf(value);
            }
        } else if (type == Short.TYPE) {
            result = value != null ? (Number)Short.valueOf(value) : (Number)0;
        } else if (type == Short.class) {
            if (value != null) {
                result = Short.valueOf(value);
            }
        } else if (type == Integer.TYPE) {
            result = value != null ? Integer.valueOf(value) : Integer.valueOf(0);
        } else if (type == Integer.class) {
            if (value != null) {
                result = Integer.valueOf(value);
            }
        } else if (type == Long.TYPE) {
            result = value != null ? Long.valueOf(value) : Long.valueOf(0L);
        } else if (type == Long.class) {
            if (value != null) {
                result = Long.valueOf(value);
            }
        } else if (type == Float.TYPE) {
            result = value != null ? Float.valueOf(value) : Float.valueOf(0.0f);
        } else if (type == Float.class) {
            if (value != null) {
                result = Float.valueOf(value);
            }
        } else if (type == Double.TYPE) {
            result = value != null ? Double.valueOf(value) : Double.valueOf(0.0);
        } else if (type == Double.class) {
            if (value != null) {
                result = Double.valueOf(value);
            }
        } else if (type == BigInteger.class) {
            if (value != null) {
                result = new BigInteger(value);
            }
        } else if (type == BigDecimal.class) {
            if (value != null) {
                result = new BigDecimal(value);
            }
        } else {
            result = UNKNOWN_VALUE_TYPE;
        }
        return result;
    }

    private static Object parseArrayValues(Class<?> type, String[] values, String format) throws Exception {
        Object result = null;
        if (type == String.class) {
            result = values;
        } else if (type == Character.TYPE) {
            if (values != null) {
                char[] arr = new char[values.length];
                for (int i = 0; i < values.length; ++i) {
                    arr[i] = !values[i].isEmpty() ? values[i].charAt(0) : (char)'\u0000';
                }
                result = arr;
            } else {
                result = new char[0];
            }
        } else if (type == Character.class) {
            if (values != null) {
                Character[] arr = new Character[values.length];
                for (int i = 0; i < values.length; ++i) {
                    arr[i] = !values[i].isEmpty() ? Character.valueOf(values[i].charAt(0)) : null;
                }
                result = arr;
            }
        } else if (type == Date.class) {
            if (values != null) {
                Date[] arr = new Date[values.length];
                for (int i = 0; i < values.length; ++i) {
                    arr[i] = new SimpleDateFormat(format).parse(values[i]);
                }
                result = arr;
            }
        } else if (type == LocalDate.class) {
            if (values != null) {
                LocalDate[] arr = new LocalDate[values.length];
                for (int i = 0; i < values.length; ++i) {
                    DateTimeFormatter formatter = DateTimeFormatter.ofPattern(format);
                    arr[i] = LocalDate.parse(values[i], formatter);
                }
                result = arr;
            }
        } else if (type == LocalDateTime.class) {
            if (values != null) {
                LocalDateTime[] arr = new LocalDateTime[values.length];
                for (int i = 0; i < values.length; ++i) {
                    DateTimeFormatter formatter = DateTimeFormatter.ofPattern(format);
                    arr[i] = LocalDateTime.parse(values[i], formatter);
                }
                result = arr;
            }
        } else if (type == Boolean.TYPE) {
            if (values != null) {
                boolean[] arr = new boolean[values.length];
                for (int i = 0; i < values.length; ++i) {
                    arr[i] = Boolean.valueOf(values[i]);
                }
                result = arr;
            } else {
                result = new boolean[0];
            }
        } else if (type == Boolean.class) {
            if (values != null) {
                Boolean[] arr = new Boolean[values.length];
                for (int i = 0; i < values.length; ++i) {
                    arr[i] = Boolean.valueOf(values[i]);
                }
                result = arr;
            }
        } else if (type == Byte.TYPE) {
            if (values != null) {
                byte[] arr = new byte[values.length];
                for (int i = 0; i < values.length; ++i) {
                    arr[i] = Byte.parseByte(values[i]);
                }
                result = arr;
            } else {
                result = new byte[0];
            }
        } else if (type == Byte.class) {
            if (values != null) {
                Byte[] arr = new Byte[values.length];
                for (int i = 0; i < values.length; ++i) {
                    arr[i] = Byte.valueOf(values[i]);
                }
                result = arr;
            }
        } else if (type == Short.TYPE) {
            if (values != null) {
                short[] arr = new short[values.length];
                for (int i = 0; i < values.length; ++i) {
                    arr[i] = Short.parseShort(values[i]);
                }
                result = arr;
            } else {
                result = new short[0];
            }
        } else if (type == Short.class) {
            if (values != null) {
                Short[] arr = new Short[values.length];
                for (int i = 0; i < values.length; ++i) {
                    arr[i] = Short.valueOf(values[i]);
                }
                result = arr;
            }
        } else if (type == Integer.TYPE) {
            if (values != null) {
                int[] arr = new int[values.length];
                for (int i = 0; i < values.length; ++i) {
                    arr[i] = Integer.parseInt(values[i]);
                }
                result = arr;
            } else {
                result = new int[0];
            }
        } else if (type == Integer.class) {
            if (values != null) {
                Integer[] arr = new Integer[values.length];
                for (int i = 0; i < values.length; ++i) {
                    arr[i] = Integer.valueOf(values[i]);
                }
                result = arr;
            }
        } else if (type == Long.TYPE) {
            if (values != null) {
                long[] arr = new long[values.length];
                for (int i = 0; i < values.length; ++i) {
                    arr[i] = Long.parseLong(values[i]);
                }
                result = arr;
            } else {
                result = new long[0];
            }
        } else if (type == Long.class) {
            if (values != null) {
                Long[] arr = new Long[values.length];
                for (int i = 0; i < values.length; ++i) {
                    arr[i] = Long.valueOf(values[i]);
                }
                result = arr;
            }
        } else if (type == Float.TYPE) {
            if (values != null) {
                float[] arr = new float[values.length];
                for (int i = 0; i < values.length; ++i) {
                    arr[i] = Float.parseFloat(values[i]);
                }
                result = arr;
            } else {
                result = new float[0];
            }
        } else if (type == Float.class) {
            if (values != null) {
                Float[] arr = new Float[values.length];
                for (int i = 0; i < values.length; ++i) {
                    arr[i] = Float.valueOf(values[i]);
                }
                result = arr;
            }
        } else if (type == Double.TYPE) {
            if (values != null) {
                double[] arr = new double[values.length];
                for (int i = 0; i < values.length; ++i) {
                    arr[i] = Double.parseDouble(values[i]);
                }
                result = arr;
            } else {
                result = new double[0];
            }
        } else if (type == Double.class) {
            if (values != null) {
                Double[] arr = new Double[values.length];
                for (int i = 0; i < values.length; ++i) {
                    arr[i] = Double.valueOf(values[i]);
                }
                result = arr;
            }
        } else if (type == BigInteger.class) {
            if (values != null) {
                BigInteger[] arr = new BigInteger[values.length];
                for (int i = 0; i < values.length; ++i) {
                    arr[i] = new BigInteger(values[i]);
                }
                result = arr;
            }
        } else if (type == BigDecimal.class) {
            if (values != null) {
                BigDecimal[] arr = new BigDecimal[values.length];
                for (int i = 0; i < values.length; ++i) {
                    arr[i] = new BigDecimal(values[i]);
                }
                result = arr;
            }
        } else {
            result = UNKNOWN_VALUE_TYPE;
        }
        return result;
    }
}

