/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.activity.process.action;

import com.aspectran.core.activity.Activity;
import com.aspectran.core.activity.Translet;
import com.aspectran.core.activity.process.action.AbstractAction;
import com.aspectran.core.activity.process.action.ActionExecutionException;
import com.aspectran.core.context.expr.ItemEvaluator;
import com.aspectran.core.context.expr.ItemExpression;
import com.aspectran.core.context.rule.AspectAdviceRule;
import com.aspectran.core.context.rule.BeanMethodActionRule;
import com.aspectran.core.context.rule.ItemRule;
import com.aspectran.core.context.rule.ItemRuleMap;
import com.aspectran.core.context.rule.type.ActionType;
import com.aspectran.core.util.BeanUtils;
import com.aspectran.core.util.MethodUtils;
import com.aspectran.core.util.ToStringBuilder;
import com.aspectran.core.util.logging.Log;
import com.aspectran.core.util.logging.LogFactory;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;

public class BeanMethodAction
extends AbstractAction {
    private static final Log log = LogFactory.getLog(BeanMethodAction.class);
    private final BeanMethodActionRule beanMethodActionRule;
    private AspectAdviceRule aspectAdviceRule;
    private Boolean requiresTranslet;

    public BeanMethodAction(BeanMethodActionRule beanMethodActionRule) {
        this.beanMethodActionRule = beanMethodActionRule;
    }

    public AspectAdviceRule getAspectAdviceRule() {
        return this.aspectAdviceRule;
    }

    public void setAspectAdviceRule(AspectAdviceRule aspectAdviceRule) {
        this.aspectAdviceRule = aspectAdviceRule;
    }

    @Override
    public Object execute(Activity activity) throws Exception {
        Object bean = null;
        try {
            Object result;
            Method method;
            if (this.aspectAdviceRule != null) {
                bean = activity.getAspectAdviceBean(this.aspectAdviceRule.getAspectId());
                if (bean == null) {
                    throw new ActionExecutionException("No such bean; Invalid AspectAdviceRule" + this.aspectAdviceRule);
                }
            } else {
                if (this.beanMethodActionRule.getBeanClass() != null) {
                    bean = activity.getBean(this.beanMethodActionRule.getBeanClass());
                } else if (this.beanMethodActionRule.getBeanId() != null) {
                    bean = activity.getBean(this.beanMethodActionRule.getBeanId());
                }
                if (bean == null) {
                    throw new ActionExecutionException("No such bean; Invalid BeanMethodActionRule " + this.beanMethodActionRule);
                }
            }
            ItemRuleMap propertyItemRuleMap = this.beanMethodActionRule.getPropertyItemRuleMap();
            ItemRuleMap argumentItemRuleMap = this.beanMethodActionRule.getArgumentItemRuleMap();
            ItemExpression evaluator = null;
            if (propertyItemRuleMap != null && !propertyItemRuleMap.isEmpty() || argumentItemRuleMap != null && !argumentItemRuleMap.isEmpty()) {
                evaluator = new ItemExpression(activity);
            }
            if (propertyItemRuleMap != null && !propertyItemRuleMap.isEmpty()) {
                Map<String, Object> valueMap = evaluator.evaluate(propertyItemRuleMap);
                for (Map.Entry<String, Object> entry : valueMap.entrySet()) {
                    BeanUtils.setProperty(bean, entry.getKey(), entry.getValue());
                }
            }
            if ((method = this.beanMethodActionRule.getMethod()) != null) {
                if (argumentItemRuleMap != null && !argumentItemRuleMap.isEmpty()) {
                    Object[] args = BeanMethodAction.createArguments(activity, argumentItemRuleMap, evaluator, this.beanMethodActionRule.isRequiresTranslet());
                    return BeanMethodAction.invokeMethod(bean, method, args);
                }
                return BeanMethodAction.invokeMethod(activity, bean, method, this.beanMethodActionRule.isRequiresTranslet());
            }
            String methodName = this.beanMethodActionRule.getMethodName();
            if (activity.getTranslet() != null) {
                if (this.requiresTranslet == null) {
                    try {
                        result = BeanMethodAction.invokeMethod(activity, bean, methodName, argumentItemRuleMap, evaluator, true);
                        this.requiresTranslet = Boolean.TRUE;
                    }
                    catch (NoSuchMethodException e) {
                        if (log.isTraceEnabled()) {
                            log.trace("No have a Translet argument on bean method " + this.beanMethodActionRule);
                        }
                        this.requiresTranslet = Boolean.FALSE;
                        result = BeanMethodAction.invokeMethod(activity, bean, methodName, argumentItemRuleMap, evaluator, false);
                    }
                } else {
                    result = BeanMethodAction.invokeMethod(activity, bean, methodName, argumentItemRuleMap, evaluator, this.requiresTranslet);
                }
            } else {
                result = BeanMethodAction.invokeMethod(activity, bean, methodName, argumentItemRuleMap, evaluator, false);
            }
            return result;
        }
        catch (ActionExecutionException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ActionExecutionException("Failed to execute bean method action " + this + " in bean " + bean, (Throwable)e);
        }
    }

    public BeanMethodActionRule getBeanMethodActionRule() {
        return this.beanMethodActionRule;
    }

    @Override
    public String getActionId() {
        return this.beanMethodActionRule.getActionId();
    }

    @Override
    public boolean isHidden() {
        return this.beanMethodActionRule.isHidden();
    }

    @Override
    public ActionType getActionType() {
        return ActionType.BEAN_METHOD;
    }

    @Override
    public <T> T getActionRule() {
        return (T)this.getBeanMethodActionRule();
    }

    public String toString() {
        ToStringBuilder tsb = new ToStringBuilder();
        tsb.append("actionType", (Object)this.getActionType());
        tsb.append("beanMethodActionRule", this.beanMethodActionRule);
        if (this.aspectAdviceRule != null) {
            tsb.append("aspectAdviceRule", this.aspectAdviceRule.toString(true));
        }
        return tsb.toString();
    }

    private static Object invokeMethod(Activity activity, Object bean, Method method, boolean requiresTranslet) throws Exception {
        Object[] args = requiresTranslet ? new Object[]{activity.getTranslet()} : MethodUtils.EMPTY_OBJECT_ARRAY;
        return BeanMethodAction.invokeMethod(bean, method, args);
    }

    private static Object invokeMethod(Object bean, Method method, Object[] args) throws Exception {
        try {
            return method.invoke(bean, args);
        }
        catch (InvocationTargetException e) {
            if (e.getCause() != null) {
                throw (Exception)e.getCause();
            }
            throw e;
        }
    }

    private static Object invokeMethod(Activity activity, Object bean, String methodName, ItemRuleMap argumentItemRuleMap, ItemEvaluator evaluator, boolean requiresTranslet) throws Exception {
        Class[] argsTypes = null;
        Object[] argsObjects = null;
        if (argumentItemRuleMap != null && !argumentItemRuleMap.isEmpty()) {
            int argIndex;
            if (evaluator == null) {
                evaluator = new ItemExpression(activity);
            }
            Map<String, Object> valueMap = evaluator.evaluate(argumentItemRuleMap);
            int argSize = argumentItemRuleMap.size();
            if (requiresTranslet) {
                argIndex = 1;
                argsTypes = new Class[argSize + argIndex];
                argsObjects = new Object[argsTypes.length];
                argsTypes[0] = Translet.class;
                argsObjects[0] = activity.getTranslet();
            } else {
                argIndex = 0;
                argsTypes = new Class[argSize];
                argsObjects = new Object[argsTypes.length];
            }
            for (ItemRule ir : argumentItemRuleMap.values()) {
                Object o = valueMap.get(ir.getName());
                argsTypes[argIndex] = ItemRule.getPrototypeClass(ir, o);
                argsObjects[argIndex] = o;
                ++argIndex;
            }
        } else if (requiresTranslet) {
            argsTypes = new Class[]{Translet.class};
            argsObjects = new Object[]{activity.getTranslet()};
        }
        try {
            return MethodUtils.invokeMethod(bean, methodName, argsObjects, argsTypes);
        }
        catch (InvocationTargetException e) {
            if (e.getCause() != null) {
                throw (Exception)e.getCause();
            }
            throw e;
        }
    }

    private static Object[] createArguments(Activity activity, ItemRuleMap argumentItemRuleMap, ItemEvaluator evaluator, boolean requiresTranslet) {
        Object[] args;
        int index;
        if (evaluator == null) {
            evaluator = new ItemExpression(activity);
        }
        int size = argumentItemRuleMap.size();
        if (requiresTranslet) {
            index = 1;
            args = new Object[size + index];
            args[0] = activity.getTranslet();
        } else {
            index = 0;
            args = new Object[size];
        }
        Map<String, Object> valueMap = evaluator.evaluate(argumentItemRuleMap);
        for (String name : argumentItemRuleMap.keySet()) {
            Object o;
            args[index] = o = valueMap.get(name);
            ++index;
        }
        return args;
    }
}

