/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.activity.process.action;

import com.aspectran.core.activity.Activity;
import com.aspectran.core.activity.process.action.AbstractAction;
import com.aspectran.core.activity.process.action.ActionExecutionException;
import com.aspectran.core.context.expr.ItemExpression;
import com.aspectran.core.context.rule.EchoActionRule;
import com.aspectran.core.context.rule.ItemRuleMap;
import com.aspectran.core.context.rule.type.ActionType;
import com.aspectran.core.util.ToStringBuilder;

public class EchoAction
extends AbstractAction {
    private final EchoActionRule echoActionRule;

    public EchoAction(EchoActionRule echoActionRule) {
        this.echoActionRule = echoActionRule;
    }

    @Override
    public Object execute(Activity activity) throws Exception {
        ItemRuleMap itemRuleMap = this.echoActionRule.getAttributeItemRuleMap();
        if (itemRuleMap == null || itemRuleMap.isEmpty()) {
            return null;
        }
        try {
            ItemExpression evaluator = new ItemExpression(activity);
            return evaluator.evaluate(itemRuleMap);
        }
        catch (Exception e) {
            throw new ActionExecutionException("Failed to execute echo action " + this, (Throwable)e);
        }
    }

    public EchoActionRule getEchoActionRule() {
        return this.echoActionRule;
    }

    @Override
    public String getActionId() {
        return this.echoActionRule.getActionId();
    }

    @Override
    public boolean isHidden() {
        return this.echoActionRule.isHidden();
    }

    @Override
    public ActionType getActionType() {
        return ActionType.ECHO;
    }

    @Override
    public <T> T getActionRule() {
        return (T)this.echoActionRule;
    }

    public String toString() {
        ToStringBuilder tsb = new ToStringBuilder();
        tsb.append("actionType", (Object)this.getActionType());
        tsb.append("echoActionRule", this.echoActionRule);
        return tsb.toString();
    }
}

