/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.activity.process.action;

import com.aspectran.core.activity.Activity;
import com.aspectran.core.activity.process.action.AbstractAction;
import com.aspectran.core.activity.process.action.ActionExecutionException;
import com.aspectran.core.activity.process.result.ProcessResult;
import com.aspectran.core.context.expr.ItemExpression;
import com.aspectran.core.context.rule.IncludeActionRule;
import com.aspectran.core.context.rule.ItemRuleMap;
import com.aspectran.core.context.rule.type.ActionType;
import com.aspectran.core.util.ToStringBuilder;
import java.util.Map;

public class IncludeAction
extends AbstractAction {
    private final IncludeActionRule includeActionRule;

    public IncludeAction(IncludeActionRule includeActionRule) {
        this.includeActionRule = includeActionRule;
    }

    @Override
    public Object execute(Activity activity) throws Exception {
        Activity innerActivity = null;
        try {
            innerActivity = (Activity)activity.newActivity();
            innerActivity.prepare(this.includeActionRule.getTransletName(), this.includeActionRule.getMethodType());
            ItemRuleMap parameterItemRuleMap = this.includeActionRule.getParameterItemRuleMap();
            ItemRuleMap attributeItemRuleMap = this.includeActionRule.getAttributeItemRuleMap();
            if (parameterItemRuleMap != null && !parameterItemRuleMap.isEmpty() || attributeItemRuleMap != null && !attributeItemRuleMap.isEmpty()) {
                Map<String, Object> valueMap;
                ItemExpression evaluator = new ItemExpression(activity);
                if (parameterItemRuleMap != null) {
                    valueMap = evaluator.evaluate(parameterItemRuleMap);
                    for (Map.Entry<String, Object> entry : valueMap.entrySet()) {
                        innerActivity.getRequestAdapter().setParameter(entry.getKey(), entry.getValue().toString());
                    }
                }
                if (attributeItemRuleMap != null) {
                    valueMap = evaluator.evaluate(attributeItemRuleMap);
                    innerActivity.getRequestAdapter().putAllAttributes(valueMap);
                }
            }
            innerActivity.perform();
            ProcessResult processResult = innerActivity.getProcessResult();
            return processResult;
        }
        catch (Exception e) {
            throw new ActionExecutionException("Failed to execute include action " + this, (Throwable)e);
        }
        finally {
            if (innerActivity != null) {
                innerActivity.finish();
            }
        }
    }

    public IncludeActionRule getIncludeActionRule() {
        return this.includeActionRule;
    }

    @Override
    public String getActionId() {
        return this.includeActionRule.getActionId();
    }

    @Override
    public boolean isHidden() {
        return this.includeActionRule.isHidden();
    }

    @Override
    public ActionType getActionType() {
        return ActionType.INCLUDE;
    }

    @Override
    public <T> T getActionRule() {
        return (T)this.getIncludeActionRule();
    }

    public String toString() {
        ToStringBuilder tsb = new ToStringBuilder();
        tsb.append("actionType", (Object)this.getActionType());
        tsb.append("includeActionRule", this.includeActionRule);
        return tsb.toString();
    }
}

