/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.activity.process.result;

import com.aspectran.core.activity.process.result.ActionResult;
import com.aspectran.core.activity.process.result.ContentResult;
import com.aspectran.core.activity.process.result.ResultValueMap;
import com.aspectran.core.util.StringUtils;
import com.aspectran.core.util.ToStringBuilder;
import java.util.ArrayList;
import java.util.ListIterator;
import java.util.Objects;

public class ProcessResult
extends ArrayList<ContentResult> {
    private static final long serialVersionUID = 4734650376929217378L;
    private String name;
    private boolean explicit;

    public ProcessResult() {
        this(5);
    }

    public ProcessResult(int initialCapacity) {
        super(initialCapacity);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isExplicit() {
        return this.explicit;
    }

    public void setExplicit(boolean explicit) {
        this.explicit = explicit;
    }

    protected void addContentResult(ContentResult contentResult) {
        this.add(contentResult);
    }

    public ContentResult getContentResult(String name) {
        for (ContentResult contentResult : this) {
            if (!Objects.equals(name, contentResult.getName())) continue;
            return contentResult;
        }
        return null;
    }

    public ContentResult getContentResult(String name, boolean explicit) {
        for (ContentResult contentResult : this) {
            if (!Objects.equals(name, contentResult.getName()) || contentResult.isExplicit() != explicit) continue;
            return contentResult;
        }
        return null;
    }

    public ActionResult getActionResult(String actionId) {
        if (actionId == null) {
            return null;
        }
        ListIterator iterator = this.listIterator(this.size());
        while (iterator.hasPrevious()) {
            ContentResult contentResult = (ContentResult)iterator.previous();
            ActionResult actionResult = contentResult.getActionResult(actionId);
            if (actionResult == null) continue;
            return actionResult;
        }
        return null;
    }

    public Object getResultValue(String actionId) {
        if (actionId == null) {
            return null;
        }
        if (!actionId.contains(".")) {
            ActionResult actionResult = this.getActionResult(actionId);
            return actionResult != null ? actionResult.getResultValue() : null;
        }
        String[] ids = StringUtils.tokenize(actionId, ".", true);
        if (ids.length == 1) {
            ActionResult actionResult = this.getActionResult(actionId);
            return actionResult != null ? actionResult.getResultValue() : null;
        }
        ActionResult actionResult = this.getActionResult(ids[0]);
        if (actionResult == null || !(actionResult.getResultValue() instanceof ResultValueMap)) {
            return null;
        }
        ResultValueMap resultValueMap = (ResultValueMap)actionResult.getResultValue();
        for (int i = 1; i < ids.length - 1; ++i) {
            Object value = resultValueMap.get(ids[i]);
            if (value instanceof ResultValueMap) continue;
            return null;
        }
        return resultValueMap.get(ids[ids.length - 1]);
    }

    public String describe() {
        ToStringBuilder tsb = new ToStringBuilder();
        tsb.append("name", this.name);
        tsb.appendSize("size", this);
        tsb.append("values", this);
        return tsb.toString();
    }
}

