/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.activity.request;

import com.aspectran.core.activity.request.FileParameter;
import com.aspectran.core.activity.request.FileParameterMap;
import com.aspectran.core.activity.request.ParameterMap;
import com.aspectran.core.context.rule.type.MethodType;
import com.aspectran.core.util.LinkedCaseInsensitiveMultiValueMap;
import com.aspectran.core.util.MultiValueMap;
import java.io.UnsupportedEncodingException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;

public abstract class AbstractRequest {
    private MethodType requestMethod;
    private MultiValueMap<String, String> headers;
    private ParameterMap parameterMap;
    private FileParameterMap fileParameterMap;
    private Map<String, Object> attributes;
    private String encoding;
    private Locale locale;
    private TimeZone timeZone;
    private boolean maxLengthExceeded;

    public MethodType getRequestMethod() {
        return this.requestMethod;
    }

    protected void setRequestMethod(MethodType requestMethod) {
        this.requestMethod = requestMethod;
    }

    public String getHeader(String name) {
        return this.getHeaderMap().getFirst(name);
    }

    public Collection<String> getHeaders(String name) {
        return (Collection)this.getHeaderMap().get(name);
    }

    public Collection<String> getHeaderNames() {
        return this.getHeaderMap().keySet();
    }

    public boolean containsHeader(String name) {
        List values = (List)this.getHeaderMap().get(name);
        return values != null && !values.isEmpty();
    }

    public void setHeader(String name, String value) {
        this.getHeaderMap().set(name, value);
    }

    public void addHeader(String name, String value) {
        this.getHeaderMap().add(name, value);
    }

    public MultiValueMap<String, String> getHeaderMap() {
        if (this.headers == null) {
            this.headers = new LinkedCaseInsensitiveMultiValueMap<String>();
        }
        return this.headers;
    }

    public void setHeaderMap(MultiValueMap<String, String> headers) {
        this.headers = headers;
    }

    public boolean hasHeaders() {
        return this.headers != null && !this.headers.isEmpty();
    }

    public String getParameter(String name) {
        return this.getParameterMap().getParameter(name);
    }

    public String[] getParameterValues(String name) {
        return this.getParameterMap().getParameterValues(name);
    }

    public Collection<String> getParameterNames() {
        return this.getParameterMap().getParameterNames();
    }

    public void setParameter(String name, String value) {
        this.getParameterMap().setParameter(name, value);
    }

    public void setParameter(String name, String[] values) {
        this.getParameterMap().put(name, values);
    }

    public Map<String, Object> getAllParameters() {
        return this.getParameterMap().extractAsMap();
    }

    public void putAllParameters(ParameterMap parameterMap) {
        this.getParameterMap().putAll(parameterMap);
    }

    public void extractParameters(Map<String, Object> targetMap) {
        if (this.hasParameters()) {
            this.getParameterMap().extractAsMap(targetMap);
        }
    }

    public ParameterMap getParameterMap() {
        if (this.parameterMap == null) {
            this.parameterMap = new ParameterMap();
        }
        return this.parameterMap;
    }

    public void setParameterMap(ParameterMap parameterMap) {
        this.parameterMap = parameterMap;
    }

    public boolean hasParameters() {
        return this.parameterMap != null && !this.parameterMap.isEmpty();
    }

    public FileParameter getFileParameter(String name) {
        return this.getFileParameterMap().getFileParameter(name);
    }

    public FileParameter[] getFileParameterValues(String name) {
        return this.getFileParameterMap().getFileParameterValues(name);
    }

    public Collection<String> getFileParameterNames() {
        return this.getFileParameterMap().keySet();
    }

    public void setFileParameter(String name, FileParameter fileParameter) {
        this.getFileParameterMap().setFileParameter(name, fileParameter);
    }

    public void setFileParameter(String name, FileParameter[] fileParameters) {
        this.getFileParameterMap().setFileParameter(name, fileParameters);
    }

    public void removeFileParameter(String name) {
        this.getFileParameterMap().remove(name);
    }

    public FileParameterMap getFileParameterMap() {
        if (this.fileParameterMap == null) {
            this.fileParameterMap = new FileParameterMap();
        }
        return this.fileParameterMap;
    }

    public boolean hasFileParameters() {
        return this.fileParameterMap != null && !this.fileParameterMap.isEmpty();
    }

    public <T> T getAttribute(String name) {
        return (T)this.getAttributeMap().get(name);
    }

    public void setAttribute(String name, Object value) {
        if (value == null) {
            this.removeAttribute(name);
        } else {
            this.getAttributeMap().put(name, value);
        }
    }

    public Collection<String> getAttributeNames() {
        return this.getAttributeMap().keySet();
    }

    public void removeAttribute(String name) {
        this.getAttributeMap().remove(name);
    }

    public void putAllAttributes(Map<String, Object> attributes) {
        this.getAttributeMap().putAll(attributes);
    }

    public void extractAttributes(Map<String, Object> targetMap) {
        if (targetMap == null) {
            throw new IllegalArgumentException("targetMap must not be null");
        }
        if (this.hasAttributes()) {
            targetMap.putAll(this.getAttributeMap());
        }
    }

    public Map<String, Object> getAttributeMap() {
        if (this.attributes == null) {
            this.attributes = new HashMap<String, Object>();
        }
        return this.attributes;
    }

    public void setAttributeMap(Map<String, Object> attributeMap) {
        this.attributes = attributeMap;
    }

    public boolean hasAttributes() {
        return this.attributes != null && !this.attributes.isEmpty();
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) throws UnsupportedEncodingException {
        this.encoding = encoding;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    public void setTimeZone(TimeZone timeZone) {
        this.timeZone = timeZone;
    }

    public void setMaxLengthExceeded(boolean maxLengthExceeded) {
        this.maxLengthExceeded = maxLengthExceeded;
    }

    public boolean isMaxLengthExceeded() {
        return this.maxLengthExceeded;
    }
}

