/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.activity.response.transform;

import com.aspectran.core.activity.Activity;
import com.aspectran.core.activity.process.ActionList;
import com.aspectran.core.activity.process.result.ProcessResult;
import com.aspectran.core.activity.response.Response;
import com.aspectran.core.activity.response.transform.TransformResponse;
import com.aspectran.core.activity.response.transform.TransformResponseException;
import com.aspectran.core.activity.response.transform.apon.ContentsAponReader;
import com.aspectran.core.adapter.ResponseAdapter;
import com.aspectran.core.context.rule.TransformRule;
import com.aspectran.core.util.apon.AponWriter;
import com.aspectran.core.util.apon.Parameters;
import com.aspectran.core.util.logging.Log;
import com.aspectran.core.util.logging.LogFactory;
import java.io.Writer;

public class AponTransformResponse
extends TransformResponse {
    private static final Log log = LogFactory.getLog(AponTransformResponse.class);
    private final String encoding;
    private final String contentType;
    private final Boolean pretty;

    public AponTransformResponse(TransformRule transformRule) {
        super(transformRule);
        this.encoding = transformRule.getEncoding();
        this.contentType = transformRule.getContentType();
        this.pretty = transformRule.getPretty();
    }

    @Override
    public void commit(Activity activity) throws TransformResponseException {
        ResponseAdapter responseAdapter = activity.getResponseAdapter();
        if (responseAdapter == null) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug("Response " + this.transformRule);
        }
        try {
            String indentString;
            if (this.encoding != null) {
                responseAdapter.setEncoding(this.encoding);
            } else {
                String encoding = activity.getTranslet().getResponseEncoding();
                if (encoding != null) {
                    responseAdapter.setEncoding(encoding);
                }
            }
            if (this.contentType != null) {
                responseAdapter.setContentType(this.contentType);
            }
            Writer writer = responseAdapter.getWriter();
            ProcessResult processResult = activity.getProcessResult();
            Parameters parameters = ContentsAponReader.read(processResult);
            AponWriter aponWriter = this.pretty == Boolean.FALSE ? new AponWriter(writer, false) : ((indentString = (String)activity.getSetting("indentString")) != null ? new AponWriter(writer, indentString) : new AponWriter(writer, this.pretty != null));
            aponWriter.write(parameters);
        }
        catch (Exception e) {
            throw new TransformResponseException(this.transformRule, (Throwable)e);
        }
    }

    @Override
    public ActionList getActionList() {
        return this.transformRule.getActionList();
    }

    @Override
    public Response replicate() {
        TransformRule transformRule = this.getTransformRule().replicate();
        return new AponTransformResponse(transformRule);
    }
}

