/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.activity.response.transform;

import com.aspectran.core.activity.Activity;
import com.aspectran.core.activity.process.ActionList;
import com.aspectran.core.activity.process.result.ProcessResult;
import com.aspectran.core.activity.response.Response;
import com.aspectran.core.activity.response.transform.TransformResponse;
import com.aspectran.core.activity.response.transform.TransformResponseException;
import com.aspectran.core.activity.response.transform.json.ContentsJsonWriter;
import com.aspectran.core.adapter.ResponseAdapter;
import com.aspectran.core.context.rule.TransformRule;
import com.aspectran.core.util.json.JsonWriter;
import com.aspectran.core.util.logging.Log;
import com.aspectran.core.util.logging.LogFactory;
import java.io.Writer;

public class JsonTransformResponse
extends TransformResponse {
    private static final Log log = LogFactory.getLog(JsonTransformResponse.class);
    private static final String CALLBACK_PARAM_NAME = "callback";
    private static final String ROUND_BRACKET_OPEN = "(";
    private static final String ROUND_BRACKET_CLOSE = ")";
    private final String encoding;
    private final String contentType;
    private final Boolean pretty;

    public JsonTransformResponse(TransformRule transformRule) {
        super(transformRule);
        this.encoding = transformRule.getEncoding();
        this.contentType = transformRule.getContentType();
        this.pretty = transformRule.getPretty();
    }

    @Override
    public void commit(Activity activity) throws TransformResponseException {
        ResponseAdapter responseAdapter = activity.getResponseAdapter();
        if (responseAdapter == null) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug("Response " + this.transformRule);
        }
        try {
            String indentString;
            if (this.encoding != null) {
                responseAdapter.setEncoding(this.encoding);
            } else {
                String encoding = activity.getTranslet().getResponseEncoding();
                if (encoding != null) {
                    responseAdapter.setEncoding(encoding);
                }
            }
            if (this.contentType != null) {
                responseAdapter.setContentType(this.contentType);
            }
            Writer writer = responseAdapter.getWriter();
            ProcessResult processResult = activity.getProcessResult();
            String callback = activity.getTranslet().getParameter(CALLBACK_PARAM_NAME);
            if (callback != null) {
                writer.write(callback + ROUND_BRACKET_OPEN);
            }
            ContentsJsonWriter jsonWriter = this.pretty == Boolean.FALSE ? new ContentsJsonWriter(writer, false) : ((indentString = (String)activity.getSetting("indentString")) != null ? new ContentsJsonWriter(writer, indentString) : new ContentsJsonWriter(writer, this.pretty != null));
            ((JsonWriter)jsonWriter).write(processResult);
            if (callback != null) {
                writer.write(ROUND_BRACKET_CLOSE);
            }
        }
        catch (Exception e) {
            throw new TransformResponseException(this.transformRule, (Throwable)e);
        }
    }

    @Override
    public ActionList getActionList() {
        return this.transformRule.getActionList();
    }

    @Override
    public Response replicate() {
        return new JsonTransformResponse(this.getTransformRule().replicate());
    }
}

