/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.activity.response.transform;

import com.aspectran.core.activity.Activity;
import com.aspectran.core.activity.process.ActionList;
import com.aspectran.core.activity.process.result.ActionResult;
import com.aspectran.core.activity.process.result.ContentResult;
import com.aspectran.core.activity.process.result.ProcessResult;
import com.aspectran.core.activity.response.Response;
import com.aspectran.core.activity.response.transform.TransformResponse;
import com.aspectran.core.activity.response.transform.TransformResponseException;
import com.aspectran.core.adapter.ResponseAdapter;
import com.aspectran.core.context.rule.TemplateRule;
import com.aspectran.core.context.rule.TransformRule;
import com.aspectran.core.util.logging.Log;
import com.aspectran.core.util.logging.LogFactory;
import java.io.Writer;

public class TextTransformResponse
extends TransformResponse {
    private static final Log log = LogFactory.getLog(TextTransformResponse.class);
    private final String templateId;
    private final TemplateRule templateRule;
    private final String encoding;
    private final String contentType;

    public TextTransformResponse(TransformRule transformRule) {
        super(transformRule);
        this.templateId = transformRule.getTemplateId();
        this.templateRule = transformRule.getTemplateRule();
        this.encoding = transformRule.getEncoding();
        this.contentType = transformRule.getContentType();
    }

    @Override
    public void commit(Activity activity) throws TransformResponseException {
        ResponseAdapter responseAdapter = activity.getResponseAdapter();
        if (responseAdapter == null) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug("Response " + this.transformRule);
        }
        try {
            if (this.encoding != null) {
                responseAdapter.setEncoding(this.encoding);
            } else {
                String encoding = activity.getTranslet().getResponseEncoding();
                if (encoding != null) {
                    responseAdapter.setEncoding(encoding);
                }
            }
            if (this.contentType != null) {
                responseAdapter.setContentType(this.contentType);
            }
            Writer writer = responseAdapter.getWriter();
            if (this.templateId != null) {
                activity.getActivityContext().getTemplateRenderer().render(this.templateId, activity);
            } else if (this.templateRule != null) {
                activity.getActivityContext().getTemplateRenderer().render(this.templateRule, activity);
            } else {
                ProcessResult processResult = activity.getProcessResult();
                if (processResult != null) {
                    int chunks = 0;
                    for (ContentResult contentResult : processResult) {
                        for (ActionResult actionResult : contentResult) {
                            Object resultValue = actionResult.getResultValue();
                            if (resultValue == null) continue;
                            if (chunks++ > 0) {
                                writer.write(System.lineSeparator());
                            }
                            writer.write(resultValue.toString());
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            throw new TransformResponseException(this.transformRule, (Throwable)e);
        }
    }

    @Override
    public ActionList getActionList() {
        return this.transformRule.getActionList();
    }

    @Override
    public Response replicate() {
        return new TextTransformResponse(this.getTransformRule().replicate());
    }
}

