/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.activity.response.transform;

import com.aspectran.core.activity.response.Response;
import com.aspectran.core.activity.response.transform.AponTransformResponse;
import com.aspectran.core.activity.response.transform.JsonTransformResponse;
import com.aspectran.core.activity.response.transform.NoneTransformResponse;
import com.aspectran.core.activity.response.transform.TextTransformResponse;
import com.aspectran.core.activity.response.transform.TransformResponse;
import com.aspectran.core.activity.response.transform.XmlTransformResponse;
import com.aspectran.core.activity.response.transform.XslTransformResponse;
import com.aspectran.core.context.rule.TransformRule;
import com.aspectran.core.context.rule.type.ContentType;
import com.aspectran.core.context.rule.type.TransformType;

public class TransformResponseFactory {
    public static Response createTransformResponse(TransformRule transformRule) {
        TransformResponse transformResponse;
        TransformType transformType = transformRule.getTransformType();
        if (transformType == TransformType.XSL) {
            transformResponse = new XslTransformResponse(transformRule);
        } else if (transformType == TransformType.XML) {
            if (transformRule.getContentType() == null) {
                transformRule.setContentType(ContentType.TEXT_XML.toString());
            }
            transformResponse = new XmlTransformResponse(transformRule);
        } else if (transformType == TransformType.TEXT) {
            transformResponse = new TextTransformResponse(transformRule);
        } else if (transformType == TransformType.JSON) {
            if (transformRule.getContentType() == null) {
                transformRule.setContentType(ContentType.TEXT_PLAIN.toString());
            }
            transformResponse = new JsonTransformResponse(transformRule);
        } else if (transformType == TransformType.APON) {
            if (transformRule.getContentType() == null) {
                transformRule.setContentType(ContentType.TEXT_PLAIN.toString());
            }
            transformResponse = new AponTransformResponse(transformRule);
        } else {
            transformResponse = new NoneTransformResponse(transformRule);
        }
        return transformResponse;
    }
}

